@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dataprotection.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Secret store based authentication credentials.
 * @property objectType Type of the specific object - used for deserializing
 * Expected value is 'SecretStoreBasedAuthCredentials'.
 * @property secretStoreResource Secret store resource
 */
public data class SecretStoreBasedAuthCredentialsResponse(
    public val objectType: String,
    public val secretStoreResource: SecretStoreResourceResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dataprotection.outputs.SecretStoreBasedAuthCredentialsResponse):
            SecretStoreBasedAuthCredentialsResponse = SecretStoreBasedAuthCredentialsResponse(
            objectType = javaType.objectType(),
            secretStoreResource = javaType.secretStoreResource().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dataprotection.kotlin.outputs.SecretStoreResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
