@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin

import com.pulumi.azurenative.datareplication.DatareplicationFunctions.getDraPlain
import com.pulumi.azurenative.datareplication.DatareplicationFunctions.getFabricPlain
import com.pulumi.azurenative.datareplication.DatareplicationFunctions.getPolicyPlain
import com.pulumi.azurenative.datareplication.DatareplicationFunctions.getProtectedItemPlain
import com.pulumi.azurenative.datareplication.DatareplicationFunctions.getReplicationExtensionPlain
import com.pulumi.azurenative.datareplication.DatareplicationFunctions.getVaultPlain
import com.pulumi.azurenative.datareplication.kotlin.inputs.GetDraPlainArgs
import com.pulumi.azurenative.datareplication.kotlin.inputs.GetDraPlainArgsBuilder
import com.pulumi.azurenative.datareplication.kotlin.inputs.GetFabricPlainArgs
import com.pulumi.azurenative.datareplication.kotlin.inputs.GetFabricPlainArgsBuilder
import com.pulumi.azurenative.datareplication.kotlin.inputs.GetPolicyPlainArgs
import com.pulumi.azurenative.datareplication.kotlin.inputs.GetPolicyPlainArgsBuilder
import com.pulumi.azurenative.datareplication.kotlin.inputs.GetProtectedItemPlainArgs
import com.pulumi.azurenative.datareplication.kotlin.inputs.GetProtectedItemPlainArgsBuilder
import com.pulumi.azurenative.datareplication.kotlin.inputs.GetReplicationExtensionPlainArgs
import com.pulumi.azurenative.datareplication.kotlin.inputs.GetReplicationExtensionPlainArgsBuilder
import com.pulumi.azurenative.datareplication.kotlin.inputs.GetVaultPlainArgs
import com.pulumi.azurenative.datareplication.kotlin.inputs.GetVaultPlainArgsBuilder
import com.pulumi.azurenative.datareplication.kotlin.outputs.GetDraResult
import com.pulumi.azurenative.datareplication.kotlin.outputs.GetFabricResult
import com.pulumi.azurenative.datareplication.kotlin.outputs.GetPolicyResult
import com.pulumi.azurenative.datareplication.kotlin.outputs.GetProtectedItemResult
import com.pulumi.azurenative.datareplication.kotlin.outputs.GetReplicationExtensionResult
import com.pulumi.azurenative.datareplication.kotlin.outputs.GetVaultResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.datareplication.kotlin.outputs.GetDraResult.Companion.toKotlin as getDraResultToKotlin
import com.pulumi.azurenative.datareplication.kotlin.outputs.GetFabricResult.Companion.toKotlin as getFabricResultToKotlin
import com.pulumi.azurenative.datareplication.kotlin.outputs.GetPolicyResult.Companion.toKotlin as getPolicyResultToKotlin
import com.pulumi.azurenative.datareplication.kotlin.outputs.GetProtectedItemResult.Companion.toKotlin as getProtectedItemResultToKotlin
import com.pulumi.azurenative.datareplication.kotlin.outputs.GetReplicationExtensionResult.Companion.toKotlin as getReplicationExtensionResultToKotlin
import com.pulumi.azurenative.datareplication.kotlin.outputs.GetVaultResult.Companion.toKotlin as getVaultResultToKotlin

public object DatareplicationFunctions {
    /**
     * Gets the details of the fabric agent.
     * Azure REST API version: 2021-02-16-preview.
     * @param argument null
     * @return Dra model.
     */
    public suspend fun getDra(argument: GetDraPlainArgs): GetDraResult =
        getDraResultToKotlin(getDraPlain(argument.toJava()).await())

    /**
     * @see [getDra].
     * @param fabricAgentName The fabric agent (Dra) name.
     * @param fabricName The fabric name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Dra model.
     */
    public suspend fun getDra(
        fabricAgentName: String,
        fabricName: String,
        resourceGroupName: String,
    ): GetDraResult {
        val argument = GetDraPlainArgs(
            fabricAgentName = fabricAgentName,
            fabricName = fabricName,
            resourceGroupName = resourceGroupName,
        )
        return getDraResultToKotlin(getDraPlain(argument.toJava()).await())
    }

    /**
     * @see [getDra].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datareplication&#46;kotlin&#46;inputs&#46;GetDraPlainArgs].
     * @return Dra model.
     */
    public suspend fun getDra(argument: suspend GetDraPlainArgsBuilder.() -> Unit): GetDraResult {
        val builder = GetDraPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDraResultToKotlin(getDraPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the fabric.
     * Azure REST API version: 2021-02-16-preview.
     * @param argument null
     * @return Fabric model.
     */
    public suspend fun getFabric(argument: GetFabricPlainArgs): GetFabricResult =
        getFabricResultToKotlin(getFabricPlain(argument.toJava()).await())

    /**
     * @see [getFabric].
     * @param fabricName The fabric name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Fabric model.
     */
    public suspend fun getFabric(fabricName: String, resourceGroupName: String): GetFabricResult {
        val argument = GetFabricPlainArgs(
            fabricName = fabricName,
            resourceGroupName = resourceGroupName,
        )
        return getFabricResultToKotlin(getFabricPlain(argument.toJava()).await())
    }

    /**
     * @see [getFabric].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datareplication&#46;kotlin&#46;inputs&#46;GetFabricPlainArgs].
     * @return Fabric model.
     */
    public suspend fun getFabric(argument: suspend GetFabricPlainArgsBuilder.() -> Unit):
        GetFabricResult {
        val builder = GetFabricPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFabricResultToKotlin(getFabricPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the policy.
     * Azure REST API version: 2021-02-16-preview.
     * @param argument null
     * @return Policy model.
     */
    public suspend fun getPolicy(argument: GetPolicyPlainArgs): GetPolicyResult =
        getPolicyResultToKotlin(getPolicyPlain(argument.toJava()).await())

    /**
     * @see [getPolicy].
     * @param policyName The policy name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The vault name.
     * @return Policy model.
     */
    public suspend fun getPolicy(
        policyName: String,
        resourceGroupName: String,
        vaultName: String,
    ): GetPolicyResult {
        val argument = GetPolicyPlainArgs(
            policyName = policyName,
            resourceGroupName = resourceGroupName,
            vaultName = vaultName,
        )
        return getPolicyResultToKotlin(getPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datareplication&#46;kotlin&#46;inputs&#46;GetPolicyPlainArgs].
     * @return Policy model.
     */
    public suspend fun getPolicy(argument: suspend GetPolicyPlainArgsBuilder.() -> Unit):
        GetPolicyResult {
        val builder = GetPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPolicyResultToKotlin(getPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the protected item.
     * Azure REST API version: 2021-02-16-preview.
     * @param argument null
     * @return Protected item model.
     */
    public suspend fun getProtectedItem(argument: GetProtectedItemPlainArgs): GetProtectedItemResult =
        getProtectedItemResultToKotlin(getProtectedItemPlain(argument.toJava()).await())

    /**
     * @see [getProtectedItem].
     * @param protectedItemName The protected item name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The vault name.
     * @return Protected item model.
     */
    public suspend fun getProtectedItem(
        protectedItemName: String,
        resourceGroupName: String,
        vaultName: String,
    ): GetProtectedItemResult {
        val argument = GetProtectedItemPlainArgs(
            protectedItemName = protectedItemName,
            resourceGroupName = resourceGroupName,
            vaultName = vaultName,
        )
        return getProtectedItemResultToKotlin(getProtectedItemPlain(argument.toJava()).await())
    }

    /**
     * @see [getProtectedItem].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datareplication&#46;kotlin&#46;inputs&#46;GetProtectedItemPlainArgs].
     * @return Protected item model.
     */
    public suspend
    fun getProtectedItem(argument: suspend GetProtectedItemPlainArgsBuilder.() -> Unit):
        GetProtectedItemResult {
        val builder = GetProtectedItemPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProtectedItemResultToKotlin(getProtectedItemPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the replication extension.
     * Azure REST API version: 2021-02-16-preview.
     * @param argument null
     * @return Replication extension model.
     */
    public suspend fun getReplicationExtension(argument: GetReplicationExtensionPlainArgs):
        GetReplicationExtensionResult =
        getReplicationExtensionResultToKotlin(getReplicationExtensionPlain(argument.toJava()).await())

    /**
     * @see [getReplicationExtension].
     * @param replicationExtensionName The replication extension name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The vault name.
     * @return Replication extension model.
     */
    public suspend fun getReplicationExtension(
        replicationExtensionName: String,
        resourceGroupName: String,
        vaultName: String,
    ): GetReplicationExtensionResult {
        val argument = GetReplicationExtensionPlainArgs(
            replicationExtensionName = replicationExtensionName,
            resourceGroupName = resourceGroupName,
            vaultName = vaultName,
        )
        return getReplicationExtensionResultToKotlin(getReplicationExtensionPlain(argument.toJava()).await())
    }

    /**
     * @see [getReplicationExtension].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datareplication&#46;kotlin&#46;inputs&#46;GetReplicationExtensionPlainArgs].
     * @return Replication extension model.
     */
    public suspend
    fun getReplicationExtension(argument: suspend GetReplicationExtensionPlainArgsBuilder.() -> Unit):
        GetReplicationExtensionResult {
        val builder = GetReplicationExtensionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReplicationExtensionResultToKotlin(getReplicationExtensionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the vault.
     * Azure REST API version: 2021-02-16-preview.
     * @param argument null
     * @return Vault model.
     */
    public suspend fun getVault(argument: GetVaultPlainArgs): GetVaultResult =
        getVaultResultToKotlin(getVaultPlain(argument.toJava()).await())

    /**
     * @see [getVault].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param vaultName The vault name.
     * @return Vault model.
     */
    public suspend fun getVault(resourceGroupName: String, vaultName: String): GetVaultResult {
        val argument = GetVaultPlainArgs(
            resourceGroupName = resourceGroupName,
            vaultName = vaultName,
        )
        return getVaultResultToKotlin(getVaultPlain(argument.toJava()).await())
    }

    /**
     * @see [getVault].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datareplication&#46;kotlin&#46;inputs&#46;GetVaultPlainArgs].
     * @return Vault model.
     */
    public suspend fun getVault(argument: suspend GetVaultPlainArgsBuilder.() -> Unit):
        GetVaultResult {
        val builder = GetVaultPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVaultResultToKotlin(getVaultPlain(builtArgument.toJava()).await())
    }
}
