@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin

import com.pulumi.azurenative.datareplication.kotlin.outputs.DraModelPropertiesResponse
import com.pulumi.azurenative.datareplication.kotlin.outputs.DraModelResponseSystemData
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.datareplication.kotlin.outputs.DraModelPropertiesResponse.Companion.toKotlin as draModelPropertiesResponseToKotlin
import com.pulumi.azurenative.datareplication.kotlin.outputs.DraModelResponseSystemData.Companion.toKotlin as draModelResponseSystemDataToKotlin

/**
 * Builder for [Dra].
 */
@PulumiTagMarker
public class DraResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DraArgs = DraArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DraArgsBuilder.() -> Unit) {
        val builder = DraArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Dra {
        val builtJavaResource = com.pulumi.azurenative.datareplication.Dra(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Dra(builtJavaResource)
    }
}

/**
 * Dra model.
 * Azure REST API version: 2021-02-16-preview.
 * ## Example Usage
 * ### Dra_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dra = new AzureNative.DataReplication.Dra("dra", new()
 *     {
 *         FabricAgentName = "M",
 *         FabricName = "wPR",
 *         Properties = new AzureNative.DataReplication.Inputs.DraModelPropertiesArgs
 *         {
 *             AuthenticationIdentity = new AzureNative.DataReplication.Inputs.IdentityModelArgs
 *             {
 *                 AadAuthority = "bubwwbowfhdmujrt",
 *                 ApplicationId = "cwktzrwajuvfyyymfstpey",
 *                 Audience = "dkjobanyqgzenivyxhvavottpc",
 *                 ObjectId = "khsiaqfbpuhp",
 *                 TenantId = "joclkkdovixwapephhxaqtefubhhmq",
 *             },
 *             CustomProperties = null,
 *             MachineId = "envzcoijbqhtrpncbjbhk",
 *             MachineName = "y",
 *             ResourceAccessIdentity = new AzureNative.DataReplication.Inputs.IdentityModelArgs
 *             {
 *                 AadAuthority = "bubwwbowfhdmujrt",
 *                 ApplicationId = "cwktzrwajuvfyyymfstpey",
 *                 Audience = "dkjobanyqgzenivyxhvavottpc",
 *                 ObjectId = "khsiaqfbpuhp",
 *                 TenantId = "joclkkdovixwapephhxaqtefubhhmq",
 *             },
 *         },
 *         ResourceGroupName = "rgrecoveryservicesdatareplication",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datareplication/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datareplication.NewDra(ctx, "dra", &datareplication.DraArgs{
 * 			FabricAgentName: pulumi.String("M"),
 * 			FabricName:      pulumi.String("wPR"),
 * 			Properties: datareplication.DraModelPropertiesResponse{
 * 				AuthenticationIdentity: &datareplication.IdentityModelArgs{
 * 					AadAuthority:  pulumi.String("bubwwbowfhdmujrt"),
 * 					ApplicationId: pulumi.String("cwktzrwajuvfyyymfstpey"),
 * 					Audience:      pulumi.String("dkjobanyqgzenivyxhvavottpc"),
 * 					ObjectId:      pulumi.String("khsiaqfbpuhp"),
 * 					TenantId:      pulumi.String("joclkkdovixwapephhxaqtefubhhmq"),
 * 				},
 * 				CustomProperties: nil,
 * 				MachineId:        pulumi.String("envzcoijbqhtrpncbjbhk"),
 * 				MachineName:      pulumi.String("y"),
 * 				ResourceAccessIdentity: &datareplication.IdentityModelArgs{
 * 					AadAuthority:  pulumi.String("bubwwbowfhdmujrt"),
 * 					ApplicationId: pulumi.String("cwktzrwajuvfyyymfstpey"),
 * 					Audience:      pulumi.String("dkjobanyqgzenivyxhvavottpc"),
 * 					ObjectId:      pulumi.String("khsiaqfbpuhp"),
 * 					TenantId:      pulumi.String("joclkkdovixwapephhxaqtefubhhmq"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rgrecoveryservicesdatareplication"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datareplication.Dra;
 * import com.pulumi.azurenative.datareplication.DraArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dra = new Dra("dra", DraArgs.builder()
 *             .fabricAgentName("M")
 *             .fabricName("wPR")
 *             .properties(Map.ofEntries(
 *                 Map.entry("authenticationIdentity", Map.ofEntries(
 *                     Map.entry("aadAuthority", "bubwwbowfhdmujrt"),
 *                     Map.entry("applicationId", "cwktzrwajuvfyyymfstpey"),
 *                     Map.entry("audience", "dkjobanyqgzenivyxhvavottpc"),
 *                     Map.entry("objectId", "khsiaqfbpuhp"),
 *                     Map.entry("tenantId", "joclkkdovixwapephhxaqtefubhhmq")
 *                 )),
 *                 Map.entry("customProperties", ),
 *                 Map.entry("machineId", "envzcoijbqhtrpncbjbhk"),
 *                 Map.entry("machineName", "y"),
 *                 Map.entry("resourceAccessIdentity", Map.ofEntries(
 *                     Map.entry("aadAuthority", "bubwwbowfhdmujrt"),
 *                     Map.entry("applicationId", "cwktzrwajuvfyyymfstpey"),
 *                     Map.entry("audience", "dkjobanyqgzenivyxhvavottpc"),
 *                     Map.entry("objectId", "khsiaqfbpuhp"),
 *                     Map.entry("tenantId", "joclkkdovixwapephhxaqtefubhhmq")
 *                 ))
 *             ))
 *             .resourceGroupName("rgrecoveryservicesdatareplication")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datareplication:Dra ioxmwhzrzdilxivkvhpvzexl /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationFabrics/{fabricName}/fabricAgents/{fabricAgentName}
 * ```
 */
public class Dra internal constructor(
    override val javaResource: com.pulumi.azurenative.datareplication.Dra,
) : KotlinCustomResource(javaResource, DraMapper) {
    /**
     * Gets or sets the name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Dra model properties.
     */
    public val properties: Output<DraModelPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                draModelPropertiesResponseToKotlin(args0)
            })
        })

    public val systemData: Output<DraModelResponseSystemData>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                draModelResponseSystemDataToKotlin(args0)
            })
        })

    /**
     * Gets or sets the type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DraMapper : ResourceMapper<Dra> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datareplication.Dra::class == javaResource::class

    override fun map(javaResource: Resource): Dra = Dra(
        javaResource as
            com.pulumi.azurenative.datareplication.Dra,
    )
}

/**
 * @see [Dra].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Dra].
 */
public suspend fun dra(name: String, block: suspend DraResourceBuilder.() -> Unit): Dra {
    val builder = DraResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Dra].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dra(name: String): Dra {
    val builder = DraResourceBuilder()
    builder.name(name)
    return builder.build()
}
