@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin

import com.pulumi.azurenative.datareplication.PolicyArgs.builder
import com.pulumi.azurenative.datareplication.kotlin.inputs.PolicyModelPropertiesArgs
import com.pulumi.azurenative.datareplication.kotlin.inputs.PolicyModelPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Policy model.
 * Azure REST API version: 2021-02-16-preview.
 * ## Example Usage
 * ### Policy_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policy = new AzureNative.DataReplication.Policy("policy", new()
 *     {
 *         PolicyName = "fafqwc",
 *         Properties = new AzureNative.DataReplication.Inputs.PolicyModelPropertiesArgs
 *         {
 *             CustomProperties =
 *             {
 *                 { "instanceType", "PolicyModelCustomProperties" },
 *             },
 *         },
 *         ResourceGroupName = "rgrecoveryservicesdatareplication",
 *         VaultName = "4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datareplication/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := datareplication.NewPolicy(ctx, "policy", &datareplication.PolicyArgs{
 * PolicyName: pulumi.String("fafqwc"),
 * Properties: interface{}{
 * CustomProperties: interface{}{
 * InstanceType: pulumi.String("PolicyModelCustomProperties"),
 * },
 * },
 * ResourceGroupName: pulumi.String("rgrecoveryservicesdatareplication"),
 * VaultName: pulumi.String("4"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datareplication.Policy;
 * import com.pulumi.azurenative.datareplication.PolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policy = new Policy("policy", PolicyArgs.builder()
 *             .policyName("fafqwc")
 *             .properties(Map.of("customProperties", Map.of("instanceType", "PolicyModelCustomProperties")))
 *             .resourceGroupName("rgrecoveryservicesdatareplication")
 *             .vaultName("4")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datareplication:Policy ocmty /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/replicationPolicies/{policyName}
 * ```
 * @property policyName The policy name.
 * @property properties Policy model properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property vaultName The vault name.
 */
public data class PolicyArgs(
    public val policyName: Output<String>? = null,
    public val properties: Output<PolicyModelPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val vaultName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datareplication.PolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.datareplication.PolicyArgs =
        com.pulumi.azurenative.datareplication.PolicyArgs.builder()
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .vaultName(vaultName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyArgs].
 */
@PulumiTagMarker
public class PolicyArgsBuilder internal constructor() {
    private var policyName: Output<String>? = null

    private var properties: Output<PolicyModelPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var vaultName: Output<String>? = null

    /**
     * @param value The policy name.
     */
    @JvmName("kdqeqmhxyaakjwty")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value Policy model properties.
     */
    @JvmName("quchvewujfgaaeua")
    public suspend fun properties(`value`: Output<PolicyModelPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nyrdvbogsbkefxnf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The vault name.
     */
    @JvmName("remskmhwdcygjvgj")
    public suspend fun vaultName(`value`: Output<String>) {
        this.vaultName = value
    }

    /**
     * @param value The policy name.
     */
    @JvmName("hhhcwekrhbqgqysp")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value Policy model properties.
     */
    @JvmName("apymiaauoofjowhb")
    public suspend fun properties(`value`: PolicyModelPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Policy model properties.
     */
    @JvmName("kourrcvtirtmmpjp")
    public suspend fun properties(argument: suspend PolicyModelPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PolicyModelPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ygexhkibcjsatrpd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The vault name.
     */
    @JvmName("kxaalnxoftqltkdy")
    public suspend fun vaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultName = mapped
    }

    internal fun build(): PolicyArgs = PolicyArgs(
        policyName = policyName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        vaultName = vaultName,
    )
}
