@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin

import com.pulumi.azurenative.datareplication.kotlin.outputs.ReplicationExtensionModelPropertiesResponse
import com.pulumi.azurenative.datareplication.kotlin.outputs.ReplicationExtensionModelResponseSystemData
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.datareplication.kotlin.outputs.ReplicationExtensionModelPropertiesResponse.Companion.toKotlin as replicationExtensionModelPropertiesResponseToKotlin
import com.pulumi.azurenative.datareplication.kotlin.outputs.ReplicationExtensionModelResponseSystemData.Companion.toKotlin as replicationExtensionModelResponseSystemDataToKotlin

/**
 * Builder for [ReplicationExtension].
 */
@PulumiTagMarker
public class ReplicationExtensionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationExtensionArgs = ReplicationExtensionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicationExtensionArgsBuilder.() -> Unit) {
        val builder = ReplicationExtensionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReplicationExtension {
        val builtJavaResource =
            com.pulumi.azurenative.datareplication.ReplicationExtension(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ReplicationExtension(builtJavaResource)
    }
}

/**
 * Replication extension model.
 * Azure REST API version: 2021-02-16-preview.
 * ## Example Usage
 * ### ReplicationExtension_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationExtension = new AzureNative.DataReplication.ReplicationExtension("replicationExtension", new()
 *     {
 *         Properties = new AzureNative.DataReplication.Inputs.ReplicationExtensionModelPropertiesArgs
 *         {
 *             CustomProperties =
 *             {
 *                 { "instanceType", "ReplicationExtensionModelCustomProperties" },
 *             },
 *         },
 *         ReplicationExtensionName = "g16yjJ",
 *         ResourceGroupName = "rgrecoveryservicesdatareplication",
 *         VaultName = "4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datareplication/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := datareplication.NewReplicationExtension(ctx, "replicationExtension", &datareplication.ReplicationExtensionArgs{
 * Properties: interface{}{
 * CustomProperties: interface{}{
 * InstanceType: pulumi.String("ReplicationExtensionModelCustomProperties"),
 * },
 * },
 * ReplicationExtensionName: pulumi.String("g16yjJ"),
 * ResourceGroupName: pulumi.String("rgrecoveryservicesdatareplication"),
 * VaultName: pulumi.String("4"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datareplication.ReplicationExtension;
 * import com.pulumi.azurenative.datareplication.ReplicationExtensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationExtension = new ReplicationExtension("replicationExtension", ReplicationExtensionArgs.builder()
 *             .properties(Map.of("customProperties", Map.of("instanceType", "ReplicationExtensionModelCustomProperties")))
 *             .replicationExtensionName("g16yjJ")
 *             .resourceGroupName("rgrecoveryservicesdatareplication")
 *             .vaultName("4")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datareplication:ReplicationExtension xvjffbiecsd /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/replicationExtensions/{replicationExtensionName}
 * ```
 */
public class ReplicationExtension internal constructor(
    override val javaResource: com.pulumi.azurenative.datareplication.ReplicationExtension,
) : KotlinCustomResource(javaResource, ReplicationExtensionMapper) {
    /**
     * Gets or sets the name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Replication extension model properties.
     */
    public val properties: Output<ReplicationExtensionModelPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                replicationExtensionModelPropertiesResponseToKotlin(args0)
            })
        })

    public val systemData: Output<ReplicationExtensionModelResponseSystemData>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                replicationExtensionModelResponseSystemDataToKotlin(args0)
            })
        })

    /**
     * Gets or sets the type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ReplicationExtensionMapper : ResourceMapper<ReplicationExtension> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datareplication.ReplicationExtension::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationExtension = ReplicationExtension(
        javaResource
            as com.pulumi.azurenative.datareplication.ReplicationExtension,
    )
}

/**
 * @see [ReplicationExtension].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationExtension].
 */
public suspend fun replicationExtension(
    name: String,
    block: suspend ReplicationExtensionResourceBuilder.() -> Unit,
): ReplicationExtension {
    val builder = ReplicationExtensionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationExtension].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationExtension(name: String): ReplicationExtension {
    val builder = ReplicationExtensionResourceBuilder()
    builder.name(name)
    return builder.build()
}
