@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin

import com.pulumi.azurenative.datareplication.ReplicationExtensionArgs.builder
import com.pulumi.azurenative.datareplication.kotlin.inputs.ReplicationExtensionModelPropertiesArgs
import com.pulumi.azurenative.datareplication.kotlin.inputs.ReplicationExtensionModelPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Replication extension model.
 * Azure REST API version: 2021-02-16-preview.
 * ## Example Usage
 * ### ReplicationExtension_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationExtension = new AzureNative.DataReplication.ReplicationExtension("replicationExtension", new()
 *     {
 *         Properties = new AzureNative.DataReplication.Inputs.ReplicationExtensionModelPropertiesArgs
 *         {
 *             CustomProperties =
 *             {
 *                 { "instanceType", "ReplicationExtensionModelCustomProperties" },
 *             },
 *         },
 *         ReplicationExtensionName = "g16yjJ",
 *         ResourceGroupName = "rgrecoveryservicesdatareplication",
 *         VaultName = "4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datareplication/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := datareplication.NewReplicationExtension(ctx, "replicationExtension", &datareplication.ReplicationExtensionArgs{
 * Properties: interface{}{
 * CustomProperties: interface{}{
 * InstanceType: pulumi.String("ReplicationExtensionModelCustomProperties"),
 * },
 * },
 * ReplicationExtensionName: pulumi.String("g16yjJ"),
 * ResourceGroupName: pulumi.String("rgrecoveryservicesdatareplication"),
 * VaultName: pulumi.String("4"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datareplication.ReplicationExtension;
 * import com.pulumi.azurenative.datareplication.ReplicationExtensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationExtension = new ReplicationExtension("replicationExtension", ReplicationExtensionArgs.builder()
 *             .properties(Map.of("customProperties", Map.of("instanceType", "ReplicationExtensionModelCustomProperties")))
 *             .replicationExtensionName("g16yjJ")
 *             .resourceGroupName("rgrecoveryservicesdatareplication")
 *             .vaultName("4")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datareplication:ReplicationExtension xvjffbiecsd /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}/replicationExtensions/{replicationExtensionName}
 * ```
 * @property properties Replication extension model properties.
 * @property replicationExtensionName The replication extension name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property vaultName The vault name.
 */
public data class ReplicationExtensionArgs(
    public val properties: Output<ReplicationExtensionModelPropertiesArgs>? = null,
    public val replicationExtensionName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val vaultName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datareplication.ReplicationExtensionArgs> {
    override fun toJava(): com.pulumi.azurenative.datareplication.ReplicationExtensionArgs =
        com.pulumi.azurenative.datareplication.ReplicationExtensionArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .replicationExtensionName(replicationExtensionName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .vaultName(vaultName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicationExtensionArgs].
 */
@PulumiTagMarker
public class ReplicationExtensionArgsBuilder internal constructor() {
    private var properties: Output<ReplicationExtensionModelPropertiesArgs>? = null

    private var replicationExtensionName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var vaultName: Output<String>? = null

    /**
     * @param value Replication extension model properties.
     */
    @JvmName("lstihhnvhakwpfoh")
    public suspend fun properties(`value`: Output<ReplicationExtensionModelPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The replication extension name.
     */
    @JvmName("oupaualrhopbhkgr")
    public suspend fun replicationExtensionName(`value`: Output<String>) {
        this.replicationExtensionName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hadrvyxstbkppaqb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The vault name.
     */
    @JvmName("ecakcceslvexfohn")
    public suspend fun vaultName(`value`: Output<String>) {
        this.vaultName = value
    }

    /**
     * @param value Replication extension model properties.
     */
    @JvmName("dogchmmpoknkonvh")
    public suspend fun properties(`value`: ReplicationExtensionModelPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Replication extension model properties.
     */
    @JvmName("lhnvqelpasdltaqw")
    public suspend
    fun properties(argument: suspend ReplicationExtensionModelPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ReplicationExtensionModelPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The replication extension name.
     */
    @JvmName("rauwxacqgntcnjtb")
    public suspend fun replicationExtensionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationExtensionName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jajeojwjekoieaeh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The vault name.
     */
    @JvmName("tmwhbfbqdwixjppj")
    public suspend fun vaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultName = mapped
    }

    internal fun build(): ReplicationExtensionArgs = ReplicationExtensionArgs(
        properties = properties,
        replicationExtensionName = replicationExtensionName,
        resourceGroupName = resourceGroupName,
        vaultName = vaultName,
    )
}
