@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin

import com.pulumi.azurenative.datareplication.kotlin.outputs.VaultModelPropertiesResponse
import com.pulumi.azurenative.datareplication.kotlin.outputs.VaultModelResponseSystemData
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.datareplication.kotlin.outputs.VaultModelPropertiesResponse.Companion.toKotlin as vaultModelPropertiesResponseToKotlin
import com.pulumi.azurenative.datareplication.kotlin.outputs.VaultModelResponseSystemData.Companion.toKotlin as vaultModelResponseSystemDataToKotlin

/**
 * Builder for [Vault].
 */
@PulumiTagMarker
public class VaultResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VaultArgs = VaultArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VaultArgsBuilder.() -> Unit) {
        val builder = VaultArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Vault {
        val builtJavaResource = com.pulumi.azurenative.datareplication.Vault(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Vault(builtJavaResource)
    }
}

/**
 * Vault model.
 * Azure REST API version: 2021-02-16-preview.
 * ## Example Usage
 * ### Vault_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vault = new AzureNative.DataReplication.Vault("vault", new()
 *     {
 *         Location = "eck",
 *         Properties = new AzureNative.DataReplication.Inputs.VaultModelPropertiesArgs
 *         {
 *             VaultType = "DisasterRecovery",
 *         },
 *         ResourceGroupName = "rgrecoveryservicesdatareplication",
 *         Tags =
 *         {
 *             { "key5359", "ljfilxolxzuxrauopwtyxghrp" },
 *         },
 *         VaultName = "4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datareplication/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datareplication.NewVault(ctx, "vault", &datareplication.VaultArgs{
 * 			Location: pulumi.String("eck"),
 * 			Properties: &datareplication.VaultModelPropertiesArgs{
 * 				VaultType: pulumi.String("DisasterRecovery"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rgrecoveryservicesdatareplication"),
 * 			Tags: pulumi.StringMap{
 * 				"key5359": pulumi.String("ljfilxolxzuxrauopwtyxghrp"),
 * 			},
 * 			VaultName: pulumi.String("4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datareplication.Vault;
 * import com.pulumi.azurenative.datareplication.VaultArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vault = new Vault("vault", VaultArgs.builder()
 *             .location("eck")
 *             .properties(Map.of("vaultType", "DisasterRecovery"))
 *             .resourceGroupName("rgrecoveryservicesdatareplication")
 *             .tags(Map.of("key5359", "ljfilxolxzuxrauopwtyxghrp"))
 *             .vaultName("4")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datareplication:Vault bqgyqxmnlgwqxbmajddqwtao /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataReplication/replicationVaults/{vaultName}
 * ```
 */
public class Vault internal constructor(
    override val javaResource: com.pulumi.azurenative.datareplication.Vault,
) : KotlinCustomResource(javaResource, VaultMapper) {
    /**
     * Gets or sets the location of the vault.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Vault properties.
     */
    public val properties: Output<VaultModelPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                vaultModelPropertiesResponseToKotlin(args0)
            })
        })

    public val systemData: Output<VaultModelResponseSystemData>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                vaultModelResponseSystemDataToKotlin(args0)
            })
        })

    /**
     * Gets or sets the resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets or sets the type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VaultMapper : ResourceMapper<Vault> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datareplication.Vault::class == javaResource::class

    override fun map(javaResource: Resource): Vault = Vault(
        javaResource as
            com.pulumi.azurenative.datareplication.Vault,
    )
}

/**
 * @see [Vault].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Vault].
 */
public suspend fun vault(name: String, block: suspend VaultResourceBuilder.() -> Unit): Vault {
    val builder = VaultResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Vault].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vault(name: String): Vault {
    val builder = VaultResourceBuilder()
    builder.name(name)
    return builder.build()
}
