@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.inputs

import com.pulumi.azurenative.datareplication.inputs.AzStackHCIClusterPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * AzStackHCI cluster properties.
 * @property clusterName Gets or sets the AzStackHCICluster FQDN name.
 * @property resourceName Gets or sets the AzStackHCICluster resource name.
 * @property storageAccountName Gets or sets the Storage account name.
 * @property storageContainers Gets or sets the list of AzStackHCICluster Storage Container.
 */
public data class AzStackHCIClusterPropertiesArgs(
    public val clusterName: Output<String>,
    public val resourceName: Output<String>,
    public val storageAccountName: Output<String>,
    public val storageContainers: Output<List<StorageContainerPropertiesArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.datareplication.inputs.AzStackHCIClusterPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datareplication.inputs.AzStackHCIClusterPropertiesArgs =
        com.pulumi.azurenative.datareplication.inputs.AzStackHCIClusterPropertiesArgs.builder()
            .clusterName(clusterName.applyValue({ args0 -> args0 }))
            .resourceName(resourceName.applyValue({ args0 -> args0 }))
            .storageAccountName(storageAccountName.applyValue({ args0 -> args0 }))
            .storageContainers(
                storageContainers.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AzStackHCIClusterPropertiesArgs].
 */
@PulumiTagMarker
public class AzStackHCIClusterPropertiesArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var storageAccountName: Output<String>? = null

    private var storageContainers: Output<List<StorageContainerPropertiesArgs>>? = null

    /**
     * @param value Gets or sets the AzStackHCICluster FQDN name.
     */
    @JvmName("xrqeoulldavoedsv")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Gets or sets the AzStackHCICluster resource name.
     */
    @JvmName("rxupwgjpecewgflt")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Gets or sets the Storage account name.
     */
    @JvmName("ltuguxqdyjuowhln")
    public suspend fun storageAccountName(`value`: Output<String>) {
        this.storageAccountName = value
    }

    /**
     * @param value Gets or sets the list of AzStackHCICluster Storage Container.
     */
    @JvmName("msbbhctajqopupyr")
    public suspend fun storageContainers(`value`: Output<List<StorageContainerPropertiesArgs>>) {
        this.storageContainers = value
    }

    @JvmName("llcbvqgarkpoejuk")
    public suspend fun storageContainers(vararg values: Output<StorageContainerPropertiesArgs>) {
        this.storageContainers = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list of AzStackHCICluster Storage Container.
     */
    @JvmName("hcgswlfydrglrisu")
    public suspend fun storageContainers(values: List<Output<StorageContainerPropertiesArgs>>) {
        this.storageContainers = Output.all(values)
    }

    /**
     * @param value Gets or sets the AzStackHCICluster FQDN name.
     */
    @JvmName("komknkxmutcqwkmg")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Gets or sets the AzStackHCICluster resource name.
     */
    @JvmName("vrueqxpxvbvkrspm")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Gets or sets the Storage account name.
     */
    @JvmName("nnbofgeqqfvbmntp")
    public suspend fun storageAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountName = mapped
    }

    /**
     * @param value Gets or sets the list of AzStackHCICluster Storage Container.
     */
    @JvmName("cqgulkwdxnkjlqrv")
    public suspend fun storageContainers(`value`: List<StorageContainerPropertiesArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageContainers = mapped
    }

    /**
     * @param argument Gets or sets the list of AzStackHCICluster Storage Container.
     */
    @JvmName("luksvfqahedokomb")
    public suspend
    fun storageContainers(argument: List<suspend StorageContainerPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StorageContainerPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageContainers = mapped
    }

    /**
     * @param argument Gets or sets the list of AzStackHCICluster Storage Container.
     */
    @JvmName("uwjoorvlabnvtgxj")
    public suspend fun storageContainers(
        vararg
        argument: suspend StorageContainerPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            StorageContainerPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageContainers = mapped
    }

    /**
     * @param argument Gets or sets the list of AzStackHCICluster Storage Container.
     */
    @JvmName("grtwcftuerpcbqkn")
    public suspend
    fun storageContainers(argument: suspend StorageContainerPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            StorageContainerPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.storageContainers = mapped
    }

    /**
     * @param values Gets or sets the list of AzStackHCICluster Storage Container.
     */
    @JvmName("cmkicwtgqxpmjnmh")
    public suspend fun storageContainers(vararg values: StorageContainerPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageContainers = mapped
    }

    internal fun build(): AzStackHCIClusterPropertiesArgs = AzStackHCIClusterPropertiesArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        storageAccountName = storageAccountName ?: throw PulumiNullFieldException("storageAccountName"),
        storageContainers = storageContainers ?: throw PulumiNullFieldException("storageContainers"),
    )
}
