@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.inputs

import com.pulumi.azurenative.datareplication.inputs.FabricModelPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Fabric model properties.
 * @property customProperties Fabric model custom properties.
 */
public data class FabricModelPropertiesArgs(
    public val customProperties: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.datareplication.inputs.FabricModelPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.datareplication.inputs.FabricModelPropertiesArgs =
        com.pulumi.azurenative.datareplication.inputs.FabricModelPropertiesArgs.builder()
            .customProperties(customProperties.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FabricModelPropertiesArgs].
 */
@PulumiTagMarker
public class FabricModelPropertiesArgsBuilder internal constructor() {
    private var customProperties: Output<Any>? = null

    /**
     * @param value Fabric model custom properties.
     */
    @JvmName("ruvhrutcxtwhpftd")
    public suspend fun customProperties(`value`: Output<Any>) {
        this.customProperties = value
    }

    /**
     * @param value Fabric model custom properties.
     */
    @JvmName("mnvhsloqdnfoakpp")
    public suspend fun customProperties(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    internal fun build(): FabricModelPropertiesArgs = FabricModelPropertiesArgs(
        customProperties = customProperties ?: throw PulumiNullFieldException("customProperties"),
    )
}
