@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.inputs

import com.pulumi.azurenative.datareplication.inputs.GetReplicationExtensionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property replicationExtensionName The replication extension name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property vaultName The vault name.
 */
public data class GetReplicationExtensionPlainArgs(
    public val replicationExtensionName: String,
    public val resourceGroupName: String,
    public val vaultName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.datareplication.inputs.GetReplicationExtensionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.datareplication.inputs.GetReplicationExtensionPlainArgs =
        com.pulumi.azurenative.datareplication.inputs.GetReplicationExtensionPlainArgs.builder()
            .replicationExtensionName(replicationExtensionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vaultName(vaultName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReplicationExtensionPlainArgs].
 */
@PulumiTagMarker
public class GetReplicationExtensionPlainArgsBuilder internal constructor() {
    private var replicationExtensionName: String? = null

    private var resourceGroupName: String? = null

    private var vaultName: String? = null

    /**
     * @param value The replication extension name.
     */
    @JvmName("onigmekfpoptivhk")
    public suspend fun replicationExtensionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.replicationExtensionName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fbxmnvkgydnfgpls")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The vault name.
     */
    @JvmName("vfktfkanbjhnwgcr")
    public suspend fun vaultName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vaultName = mapped
    }

    internal fun build(): GetReplicationExtensionPlainArgs = GetReplicationExtensionPlainArgs(
        replicationExtensionName = replicationExtensionName ?: throw
            PulumiNullFieldException("replicationExtensionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vaultName = vaultName ?: throw PulumiNullFieldException("vaultName"),
    )
}
