@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.inputs

import com.pulumi.azurenative.datareplication.inputs.HyperVToAzStackHCINicInputArgs.builder
import com.pulumi.azurenative.datareplication.kotlin.enums.VMNicSelection
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * HyperVToAzStackHCI NIC properties.
 * @property nicId Gets or sets the NIC Id.
 * @property selectionTypeForFailover Gets or sets the selection type of the NIC.
 * @property targetNetworkId Gets or sets the target network Id within AzStackHCI Cluster.
 * @property testNetworkId Gets or sets the target test network Id within AzStackHCI Cluster.
 */
public data class HyperVToAzStackHCINicInputArgs(
    public val nicId: Output<String>,
    public val selectionTypeForFailover: Output<Either<String, VMNicSelection>>,
    public val targetNetworkId: Output<String>,
    public val testNetworkId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datareplication.inputs.HyperVToAzStackHCINicInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.datareplication.inputs.HyperVToAzStackHCINicInputArgs =
        com.pulumi.azurenative.datareplication.inputs.HyperVToAzStackHCINicInputArgs.builder()
            .nicId(nicId.applyValue({ args0 -> args0 }))
            .selectionTypeForFailover(
                selectionTypeForFailover.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .targetNetworkId(targetNetworkId.applyValue({ args0 -> args0 }))
            .testNetworkId(testNetworkId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HyperVToAzStackHCINicInputArgs].
 */
@PulumiTagMarker
public class HyperVToAzStackHCINicInputArgsBuilder internal constructor() {
    private var nicId: Output<String>? = null

    private var selectionTypeForFailover: Output<Either<String, VMNicSelection>>? = null

    private var targetNetworkId: Output<String>? = null

    private var testNetworkId: Output<String>? = null

    /**
     * @param value Gets or sets the NIC Id.
     */
    @JvmName("cmgeyvjldkviayme")
    public suspend fun nicId(`value`: Output<String>) {
        this.nicId = value
    }

    /**
     * @param value Gets or sets the selection type of the NIC.
     */
    @JvmName("naublorxiafbmogp")
    public suspend fun selectionTypeForFailover(`value`: Output<Either<String, VMNicSelection>>) {
        this.selectionTypeForFailover = value
    }

    /**
     * @param value Gets or sets the target network Id within AzStackHCI Cluster.
     */
    @JvmName("lgwolvbkegoaphyt")
    public suspend fun targetNetworkId(`value`: Output<String>) {
        this.targetNetworkId = value
    }

    /**
     * @param value Gets or sets the target test network Id within AzStackHCI Cluster.
     */
    @JvmName("wiusdhlgvfwiltcv")
    public suspend fun testNetworkId(`value`: Output<String>) {
        this.testNetworkId = value
    }

    /**
     * @param value Gets or sets the NIC Id.
     */
    @JvmName("qhyppymdmtrrstoq")
    public suspend fun nicId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nicId = mapped
    }

    /**
     * @param value Gets or sets the selection type of the NIC.
     */
    @JvmName("rtxivqanxrgrqhjl")
    public suspend fun selectionTypeForFailover(`value`: Either<String, VMNicSelection>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectionTypeForFailover = mapped
    }

    /**
     * @param value Gets or sets the selection type of the NIC.
     */
    @JvmName("qrnucdbqhmfusmvw")
    public fun selectionTypeForFailover(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VMNicSelection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectionTypeForFailover = mapped
    }

    /**
     * @param value Gets or sets the selection type of the NIC.
     */
    @JvmName("ssbdqobjjctputku")
    public fun selectionTypeForFailover(`value`: VMNicSelection) {
        val toBeMapped = Either.ofRight<String, VMNicSelection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectionTypeForFailover = mapped
    }

    /**
     * @param value Gets or sets the target network Id within AzStackHCI Cluster.
     */
    @JvmName("dqpkuweqmltvgoph")
    public suspend fun targetNetworkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetNetworkId = mapped
    }

    /**
     * @param value Gets or sets the target test network Id within AzStackHCI Cluster.
     */
    @JvmName("osqpgkobcuqbcasn")
    public suspend fun testNetworkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.testNetworkId = mapped
    }

    internal fun build(): HyperVToAzStackHCINicInputArgs = HyperVToAzStackHCINicInputArgs(
        nicId = nicId ?: throw PulumiNullFieldException("nicId"),
        selectionTypeForFailover = selectionTypeForFailover ?: throw
            PulumiNullFieldException("selectionTypeForFailover"),
        targetNetworkId = targetNetworkId ?: throw PulumiNullFieldException("targetNetworkId"),
        testNetworkId = testNetworkId ?: throw PulumiNullFieldException("testNetworkId"),
    )
}
