@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.inputs

import com.pulumi.azurenative.datareplication.inputs.ReplicationExtensionModelPropertiesArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Replication extension model properties.
 * @property customProperties Replication extension model custom properties.
 */
public data class ReplicationExtensionModelPropertiesArgs(
    public val customProperties:
    Output<Either<HyperVToAzStackHCIReplicationExtensionModelCustomPropertiesArgs, VMwareToAzStackHCIReplicationExtensionModelCustomPropertiesArgs>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.datareplication.inputs.ReplicationExtensionModelPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datareplication.inputs.ReplicationExtensionModelPropertiesArgs =
        com.pulumi.azurenative.datareplication.inputs.ReplicationExtensionModelPropertiesArgs.builder()
            .customProperties(
                customProperties.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ReplicationExtensionModelPropertiesArgs].
 */
@PulumiTagMarker
public class ReplicationExtensionModelPropertiesArgsBuilder internal constructor() {
    private var customProperties:
        Output<Either<HyperVToAzStackHCIReplicationExtensionModelCustomPropertiesArgs, VMwareToAzStackHCIReplicationExtensionModelCustomPropertiesArgs>>? =
        null

    /**
     * @param value Replication extension model custom properties.
     */
    @JvmName("dravkphaedtpcqnv")
    public suspend
    fun customProperties(`value`: Output<Either<HyperVToAzStackHCIReplicationExtensionModelCustomPropertiesArgs, VMwareToAzStackHCIReplicationExtensionModelCustomPropertiesArgs>>) {
        this.customProperties = value
    }

    /**
     * @param value Replication extension model custom properties.
     */
    @JvmName("eeovntnehyqgurxi")
    public suspend
    fun customProperties(`value`: Either<HyperVToAzStackHCIReplicationExtensionModelCustomPropertiesArgs, VMwareToAzStackHCIReplicationExtensionModelCustomPropertiesArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param value Replication extension model custom properties.
     */
    @JvmName("sjatskoajafolqal")
    public
    fun customProperties(`value`: HyperVToAzStackHCIReplicationExtensionModelCustomPropertiesArgs) {
        val toBeMapped = Either.ofLeft<HyperVToAzStackHCIReplicationExtensionModelCustomPropertiesArgs,
            VMwareToAzStackHCIReplicationExtensionModelCustomPropertiesArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param value Replication extension model custom properties.
     */
    @JvmName("ujabskeecpvmguxu")
    public
    fun customProperties(`value`: VMwareToAzStackHCIReplicationExtensionModelCustomPropertiesArgs) {
        val toBeMapped = Either.ofRight<HyperVToAzStackHCIReplicationExtensionModelCustomPropertiesArgs,
            VMwareToAzStackHCIReplicationExtensionModelCustomPropertiesArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    internal fun build(): ReplicationExtensionModelPropertiesArgs =
        ReplicationExtensionModelPropertiesArgs(
            customProperties = customProperties ?: throw PulumiNullFieldException("customProperties"),
        )
}
