@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Storage container properties.
 * @property clusterSharedVolumePath Gets or sets the ClusterSharedVolumePath.
 * @property name Gets or sets the Name.
 */
public data class StorageContainerPropertiesResponse(
    public val clusterSharedVolumePath: String,
    public val name: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.StorageContainerPropertiesResponse):
            StorageContainerPropertiesResponse = StorageContainerPropertiesResponse(
            clusterSharedVolumePath = javaType.clusterSharedVolumePath(),
            name = javaType.name(),
        )
    }
}
