@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datareplication.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Vault properties.
 * @property provisioningState Gets or sets the provisioning state of the vault.
 * @property serviceResourceId Gets or sets the service resource Id.
 * @property vaultType Gets or sets the type of vault.
 */
public data class VaultModelPropertiesResponse(
    public val provisioningState: String,
    public val serviceResourceId: String,
    public val vaultType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datareplication.outputs.VaultModelPropertiesResponse):
            VaultModelPropertiesResponse = VaultModelPropertiesResponse(
            provisioningState = javaType.provisioningState(),
            serviceResourceId = javaType.serviceResourceId(),
            vaultType = javaType.vaultType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
