@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.BlobContainerDataSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An Azure storage blob container data set.
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * ## Example Usage
 * ### DataSets_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobContainerDataSet = new AzureNative.DataShare.BlobContainerDataSet("blobContainerDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobContainerDataSet(ctx, "blobContainerDataSet", &datashare.BlobContainerDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobContainerDataSet;
 * import com.pulumi.azurenative.datashare.BlobContainerDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobContainerDataSet = new BlobContainerDataSet("blobContainerDataSet", BlobContainerDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_KustoCluster_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobContainerDataSet = new AzureNative.DataShare.BlobContainerDataSet("blobContainerDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobContainerDataSet(ctx, "blobContainerDataSet", &datashare.BlobContainerDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobContainerDataSet;
 * import com.pulumi.azurenative.datashare.BlobContainerDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobContainerDataSet = new BlobContainerDataSet("blobContainerDataSet", BlobContainerDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_KustoDatabase_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobContainerDataSet = new AzureNative.DataShare.BlobContainerDataSet("blobContainerDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobContainerDataSet(ctx, "blobContainerDataSet", &datashare.BlobContainerDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobContainerDataSet;
 * import com.pulumi.azurenative.datashare.BlobContainerDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobContainerDataSet = new BlobContainerDataSet("blobContainerDataSet", BlobContainerDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_KustoTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobContainerDataSet = new AzureNative.DataShare.BlobContainerDataSet("blobContainerDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobContainerDataSet(ctx, "blobContainerDataSet", &datashare.BlobContainerDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobContainerDataSet;
 * import com.pulumi.azurenative.datashare.BlobContainerDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobContainerDataSet = new BlobContainerDataSet("blobContainerDataSet", BlobContainerDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_SqlDBTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobContainerDataSet = new AzureNative.DataShare.BlobContainerDataSet("blobContainerDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobContainerDataSet(ctx, "blobContainerDataSet", &datashare.BlobContainerDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobContainerDataSet;
 * import com.pulumi.azurenative.datashare.BlobContainerDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobContainerDataSet = new BlobContainerDataSet("blobContainerDataSet", BlobContainerDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_SqlDWTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobContainerDataSet = new AzureNative.DataShare.BlobContainerDataSet("blobContainerDataSet", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetName = "Dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobContainerDataSet(ctx, "blobContainerDataSet", &datashare.BlobContainerDataSetArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			DataSetName:       pulumi.String("Dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobContainerDataSet;
 * import com.pulumi.azurenative.datashare.BlobContainerDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobContainerDataSet = new BlobContainerDataSet("blobContainerDataSet", BlobContainerDataSetArgs.builder()
 *             .accountName("Account1")
 *             .dataSetName("Dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSets_SynapseWorkspaceSqlPoolTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobContainerDataSet = new AzureNative.DataShare.BlobContainerDataSet("blobContainerDataSet", new()
 *     {
 *         AccountName = "sourceAccount",
 *         DataSetName = "dataset1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "share1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewBlobContainerDataSet(ctx, "blobContainerDataSet", &datashare.BlobContainerDataSetArgs{
 * 			AccountName:       pulumi.String("sourceAccount"),
 * 			DataSetName:       pulumi.String("dataset1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("share1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.BlobContainerDataSet;
 * import com.pulumi.azurenative.datashare.BlobContainerDataSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobContainerDataSet = new BlobContainerDataSet("blobContainerDataSet", BlobContainerDataSetArgs.builder()
 *             .accountName("sourceAccount")
 *             .dataSetName("dataset1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("share1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:BlobContainerDataSet dataset1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/dataSets/{dataSetName}
 * ```
 * @property accountName The name of the share account.
 * @property containerName BLOB Container name.
 * @property dataSetName The name of the dataSet.
 * @property kind Kind of data set.
 * Expected value is 'Container'.
 * @property resourceGroup Resource group of storage account
 * @property resourceGroupName The resource group name.
 * @property shareName The name of the share to add the data set to.
 * @property storageAccountName Storage account name of the source data set
 * @property subscriptionId Subscription id of storage account
 */
public data class BlobContainerDataSetArgs(
    public val accountName: Output<String>? = null,
    public val containerName: Output<String>? = null,
    public val dataSetName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val resourceGroup: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val shareName: Output<String>? = null,
    public val storageAccountName: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.BlobContainerDataSetArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.BlobContainerDataSetArgs =
        com.pulumi.azurenative.datashare.BlobContainerDataSetArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .dataSetName(dataSetName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .shareName(shareName?.applyValue({ args0 -> args0 }))
            .storageAccountName(storageAccountName?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BlobContainerDataSetArgs].
 */
@PulumiTagMarker
public class BlobContainerDataSetArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var containerName: Output<String>? = null

    private var dataSetName: Output<String>? = null

    private var kind: Output<String>? = null

    private var resourceGroup: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var shareName: Output<String>? = null

    private var storageAccountName: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("fdfwpcuxpufjscre")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value BLOB Container name.
     */
    @JvmName("ieipkbuwvqbvnoym")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value The name of the dataSet.
     */
    @JvmName("tleuabiqsdgwelbt")
    public suspend fun dataSetName(`value`: Output<String>) {
        this.dataSetName = value
    }

    /**
     * @param value Kind of data set.
     * Expected value is 'Container'.
     */
    @JvmName("uwwwjbujnguqvjyh")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource group of storage account
     */
    @JvmName("getoevdtqgmiddam")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("hjvtjlhcywmkvtmn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the share to add the data set to.
     */
    @JvmName("httuexdpnxbxgmul")
    public suspend fun shareName(`value`: Output<String>) {
        this.shareName = value
    }

    /**
     * @param value Storage account name of the source data set
     */
    @JvmName("etgmqynmetwnpoiy")
    public suspend fun storageAccountName(`value`: Output<String>) {
        this.storageAccountName = value
    }

    /**
     * @param value Subscription id of storage account
     */
    @JvmName("ukmjtwhvarushstd")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value The name of the share account.
     */
    @JvmName("rwudfhxwnymrkjlq")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value BLOB Container name.
     */
    @JvmName("uaqykjddmwjjujip")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value The name of the dataSet.
     */
    @JvmName("rgwpjnchihmnogxl")
    public suspend fun dataSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetName = mapped
    }

    /**
     * @param value Kind of data set.
     * Expected value is 'Container'.
     */
    @JvmName("efnxwvmnejcxokwf")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource group of storage account
     */
    @JvmName("iylfshqvaycnlthe")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("rulwmkpglapsykko")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the share to add the data set to.
     */
    @JvmName("sskxpmwngitcutvb")
    public suspend fun shareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareName = mapped
    }

    /**
     * @param value Storage account name of the source data set
     */
    @JvmName("sctxpurnjglfwhtj")
    public suspend fun storageAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountName = mapped
    }

    /**
     * @param value Subscription id of storage account
     */
    @JvmName("xoonedubolhcwocw")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    internal fun build(): BlobContainerDataSetArgs = BlobContainerDataSetArgs(
        accountName = accountName,
        containerName = containerName,
        dataSetName = dataSetName,
        kind = kind,
        resourceGroup = resourceGroup,
        resourceGroupName = resourceGroupName,
        shareName = shareName,
        storageAccountName = storageAccountName,
        subscriptionId = subscriptionId,
    )
}
