@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Invitation].
 */
@PulumiTagMarker
public class InvitationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InvitationArgs = InvitationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InvitationArgsBuilder.() -> Unit) {
        val builder = InvitationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Invitation {
        val builtJavaResource = com.pulumi.azurenative.datashare.Invitation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Invitation(builtJavaResource)
    }
}

/**
 * A Invitation data transfer object.
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * ## Example Usage
 * ### Invitations_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var invitation = new AzureNative.DataShare.Invitation("invitation", new()
 *     {
 *         AccountName = "Account1",
 *         ExpirationDate = "2020-08-26T22:33:24.5785265Z",
 *         InvitationName = "Invitation1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *         TargetEmail = "receiver@microsoft.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewInvitation(ctx, "invitation", &datashare.InvitationArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			ExpirationDate:    pulumi.String("2020-08-26T22:33:24.5785265Z"),
 * 			InvitationName:    pulumi.String("Invitation1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 			TargetEmail:       pulumi.String("receiver@microsoft.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.Invitation;
 * import com.pulumi.azurenative.datashare.InvitationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var invitation = new Invitation("invitation", InvitationArgs.builder()
 *             .accountName("Account1")
 *             .expirationDate("2020-08-26T22:33:24.5785265Z")
 *             .invitationName("Invitation1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .targetEmail("receiver@microsoft.com")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:Invitation Invitation1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/invitations/{invitationName}
 * ```
 */
public class Invitation internal constructor(
    override val javaResource: com.pulumi.azurenative.datashare.Invitation,
) : KotlinCustomResource(javaResource, InvitationMapper) {
    /**
     * The expiration date for the invitation and share subscription.
     */
    public val expirationDate: Output<String>?
        get() = javaResource.expirationDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * unique invitation id
     */
    public val invitationId: Output<String>
        get() = javaResource.invitationId().applyValue({ args0 -> args0 })

    /**
     * The status of the invitation.
     */
    public val invitationStatus: Output<String>
        get() = javaResource.invitationStatus().applyValue({ args0 -> args0 })

    /**
     * Name of the azure resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The time the recipient responded to the invitation.
     */
    public val respondedAt: Output<String>
        get() = javaResource.respondedAt().applyValue({ args0 -> args0 })

    /**
     * Gets the time at which the invitation was sent.
     */
    public val sentAt: Output<String>
        get() = javaResource.sentAt().applyValue({ args0 -> args0 })

    /**
     * System Data of the Azure resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The target Azure AD Id. Can't be combined with email.
     */
    public val targetActiveDirectoryId: Output<String>?
        get() = javaResource.targetActiveDirectoryId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The email the invitation is directed to.
     */
    public val targetEmail: Output<String>?
        get() = javaResource.targetEmail().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The target user or application Id that invitation is being sent to.
     * Must be specified along TargetActiveDirectoryId. This enables sending
     * invitations to specific users or applications in an AD tenant.
     */
    public val targetObjectId: Output<String>?
        get() = javaResource.targetObjectId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of the azure resource
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Email of the user who created the resource
     */
    public val userEmail: Output<String>
        get() = javaResource.userEmail().applyValue({ args0 -> args0 })

    /**
     * Name of the user who created the resource
     */
    public val userName: Output<String>
        get() = javaResource.userName().applyValue({ args0 -> args0 })
}

public object InvitationMapper : ResourceMapper<Invitation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datashare.Invitation::class == javaResource::class

    override fun map(javaResource: Resource): Invitation = Invitation(
        javaResource as
            com.pulumi.azurenative.datashare.Invitation,
    )
}

/**
 * @see [Invitation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Invitation].
 */
public suspend fun invitation(name: String, block: suspend InvitationResourceBuilder.() -> Unit):
    Invitation {
    val builder = InvitationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Invitation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun invitation(name: String): Invitation {
    val builder = InvitationResourceBuilder()
    builder.name(name)
    return builder.build()
}
