@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.InvitationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A Invitation data transfer object.
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * ## Example Usage
 * ### Invitations_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var invitation = new AzureNative.DataShare.Invitation("invitation", new()
 *     {
 *         AccountName = "Account1",
 *         ExpirationDate = "2020-08-26T22:33:24.5785265Z",
 *         InvitationName = "Invitation1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareName = "Share1",
 *         TargetEmail = "receiver@microsoft.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewInvitation(ctx, "invitation", &datashare.InvitationArgs{
 * 			AccountName:       pulumi.String("Account1"),
 * 			ExpirationDate:    pulumi.String("2020-08-26T22:33:24.5785265Z"),
 * 			InvitationName:    pulumi.String("Invitation1"),
 * 			ResourceGroupName: pulumi.String("SampleResourceGroup"),
 * 			ShareName:         pulumi.String("Share1"),
 * 			TargetEmail:       pulumi.String("receiver@microsoft.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.Invitation;
 * import com.pulumi.azurenative.datashare.InvitationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var invitation = new Invitation("invitation", InvitationArgs.builder()
 *             .accountName("Account1")
 *             .expirationDate("2020-08-26T22:33:24.5785265Z")
 *             .invitationName("Invitation1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareName("Share1")
 *             .targetEmail("receiver@microsoft.com")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:Invitation Invitation1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shares/{shareName}/invitations/{invitationName}
 * ```
 * @property accountName The name of the share account.
 * @property expirationDate The expiration date for the invitation and share subscription.
 * @property invitationName The name of the invitation.
 * @property resourceGroupName The resource group name.
 * @property shareName The name of the share to send the invitation for.
 * @property targetActiveDirectoryId The target Azure AD Id. Can't be combined with email.
 * @property targetEmail The email the invitation is directed to.
 * @property targetObjectId The target user or application Id that invitation is being sent to.
 * Must be specified along TargetActiveDirectoryId. This enables sending
 * invitations to specific users or applications in an AD tenant.
 */
public data class InvitationArgs(
    public val accountName: Output<String>? = null,
    public val expirationDate: Output<String>? = null,
    public val invitationName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val shareName: Output<String>? = null,
    public val targetActiveDirectoryId: Output<String>? = null,
    public val targetEmail: Output<String>? = null,
    public val targetObjectId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.InvitationArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.InvitationArgs =
        com.pulumi.azurenative.datashare.InvitationArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .expirationDate(expirationDate?.applyValue({ args0 -> args0 }))
            .invitationName(invitationName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .shareName(shareName?.applyValue({ args0 -> args0 }))
            .targetActiveDirectoryId(targetActiveDirectoryId?.applyValue({ args0 -> args0 }))
            .targetEmail(targetEmail?.applyValue({ args0 -> args0 }))
            .targetObjectId(targetObjectId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InvitationArgs].
 */
@PulumiTagMarker
public class InvitationArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var expirationDate: Output<String>? = null

    private var invitationName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var shareName: Output<String>? = null

    private var targetActiveDirectoryId: Output<String>? = null

    private var targetEmail: Output<String>? = null

    private var targetObjectId: Output<String>? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("atxbnocumwtgwdyu")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The expiration date for the invitation and share subscription.
     */
    @JvmName("oegyijwyfoqkneuc")
    public suspend fun expirationDate(`value`: Output<String>) {
        this.expirationDate = value
    }

    /**
     * @param value The name of the invitation.
     */
    @JvmName("trkkooroylqsxvfu")
    public suspend fun invitationName(`value`: Output<String>) {
        this.invitationName = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("chkmgxyruyaxnvbc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the share to send the invitation for.
     */
    @JvmName("idacymtkdtugqphu")
    public suspend fun shareName(`value`: Output<String>) {
        this.shareName = value
    }

    /**
     * @param value The target Azure AD Id. Can't be combined with email.
     */
    @JvmName("tfrfphtxepfuxqvj")
    public suspend fun targetActiveDirectoryId(`value`: Output<String>) {
        this.targetActiveDirectoryId = value
    }

    /**
     * @param value The email the invitation is directed to.
     */
    @JvmName("jyiyicuntunkqrks")
    public suspend fun targetEmail(`value`: Output<String>) {
        this.targetEmail = value
    }

    /**
     * @param value The target user or application Id that invitation is being sent to.
     * Must be specified along TargetActiveDirectoryId. This enables sending
     * invitations to specific users or applications in an AD tenant.
     */
    @JvmName("kxomjnljtxtoqdrg")
    public suspend fun targetObjectId(`value`: Output<String>) {
        this.targetObjectId = value
    }

    /**
     * @param value The name of the share account.
     */
    @JvmName("ljprcvylawaylvir")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The expiration date for the invitation and share subscription.
     */
    @JvmName("hccpldtvvvrxamqd")
    public suspend fun expirationDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expirationDate = mapped
    }

    /**
     * @param value The name of the invitation.
     */
    @JvmName("kfjiusjqqvckrkwp")
    public suspend fun invitationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invitationName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("tuiaukihxvabugll")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the share to send the invitation for.
     */
    @JvmName("vebfmifistwuukvv")
    public suspend fun shareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareName = mapped
    }

    /**
     * @param value The target Azure AD Id. Can't be combined with email.
     */
    @JvmName("cvgfntsaihpcsiar")
    public suspend fun targetActiveDirectoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetActiveDirectoryId = mapped
    }

    /**
     * @param value The email the invitation is directed to.
     */
    @JvmName("bwpowgdyocfueacv")
    public suspend fun targetEmail(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetEmail = mapped
    }

    /**
     * @param value The target user or application Id that invitation is being sent to.
     * Must be specified along TargetActiveDirectoryId. This enables sending
     * invitations to specific users or applications in an AD tenant.
     */
    @JvmName("hhnbglppplpfxgmw")
    public suspend fun targetObjectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetObjectId = mapped
    }

    internal fun build(): InvitationArgs = InvitationArgs(
        accountName = accountName,
        expirationDate = expirationDate,
        invitationName = invitationName,
        resourceGroupName = resourceGroupName,
        shareName = shareName,
        targetActiveDirectoryId = targetActiveDirectoryId,
        targetEmail = targetEmail,
        targetObjectId = targetObjectId,
    )
}
