@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin

import com.pulumi.azurenative.datashare.KustoTableDataSetMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A Kusto database data set mapping
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * ## Example Usage
 * ### DataSetMappings_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kustoTableDataSetMapping = new AzureNative.DataShare.KustoTableDataSetMapping("kustoTableDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetMappingName = "DatasetMapping1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewKustoTableDataSetMapping(ctx, "kustoTableDataSetMapping", &datashare.KustoTableDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.KustoTableDataSetMapping;
 * import com.pulumi.azurenative.datashare.KustoTableDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kustoTableDataSetMapping = new KustoTableDataSetMapping("kustoTableDataSetMapping", KustoTableDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetMappingName("DatasetMapping1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SqlDB_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kustoTableDataSetMapping = new AzureNative.DataShare.KustoTableDataSetMapping("kustoTableDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetMappingName = "DatasetMapping1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewKustoTableDataSetMapping(ctx, "kustoTableDataSetMapping", &datashare.KustoTableDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.KustoTableDataSetMapping;
 * import com.pulumi.azurenative.datashare.KustoTableDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kustoTableDataSetMapping = new KustoTableDataSetMapping("kustoTableDataSetMapping", KustoTableDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetMappingName("DatasetMapping1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SqlDWDataSetToAdlsGen2File_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kustoTableDataSetMapping = new AzureNative.DataShare.KustoTableDataSetMapping("kustoTableDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetMappingName = "DatasetMapping1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewKustoTableDataSetMapping(ctx, "kustoTableDataSetMapping", &datashare.KustoTableDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.KustoTableDataSetMapping;
 * import com.pulumi.azurenative.datashare.KustoTableDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kustoTableDataSetMapping = new KustoTableDataSetMapping("kustoTableDataSetMapping", KustoTableDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetMappingName("DatasetMapping1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SqlDW_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kustoTableDataSetMapping = new AzureNative.DataShare.KustoTableDataSetMapping("kustoTableDataSetMapping", new()
 *     {
 *         AccountName = "Account1",
 *         DataSetMappingName = "DatasetMapping1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewKustoTableDataSetMapping(ctx, "kustoTableDataSetMapping", &datashare.KustoTableDataSetMappingArgs{
 * 			AccountName:           pulumi.String("Account1"),
 * 			DataSetMappingName:    pulumi.String("DatasetMapping1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.KustoTableDataSetMapping;
 * import com.pulumi.azurenative.datashare.KustoTableDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kustoTableDataSetMapping = new KustoTableDataSetMapping("kustoTableDataSetMapping", KustoTableDataSetMappingArgs.builder()
 *             .accountName("Account1")
 *             .dataSetMappingName("DatasetMapping1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ### DataSetMappings_SynapseWorkspaceSqlPoolTable_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kustoTableDataSetMapping = new AzureNative.DataShare.KustoTableDataSetMapping("kustoTableDataSetMapping", new()
 *     {
 *         AccountName = "consumerAccount",
 *         DataSetMappingName = "datasetMappingName1",
 *         ResourceGroupName = "SampleResourceGroup",
 *         ShareSubscriptionName = "ShareSubscription1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datashare/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datashare.NewKustoTableDataSetMapping(ctx, "kustoTableDataSetMapping", &datashare.KustoTableDataSetMappingArgs{
 * 			AccountName:           pulumi.String("consumerAccount"),
 * 			DataSetMappingName:    pulumi.String("datasetMappingName1"),
 * 			ResourceGroupName:     pulumi.String("SampleResourceGroup"),
 * 			ShareSubscriptionName: pulumi.String("ShareSubscription1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datashare.KustoTableDataSetMapping;
 * import com.pulumi.azurenative.datashare.KustoTableDataSetMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kustoTableDataSetMapping = new KustoTableDataSetMapping("kustoTableDataSetMapping", KustoTableDataSetMappingArgs.builder()
 *             .accountName("consumerAccount")
 *             .dataSetMappingName("datasetMappingName1")
 *             .resourceGroupName("SampleResourceGroup")
 *             .shareSubscriptionName("ShareSubscription1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datashare:KustoTableDataSetMapping datasetMappingName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataShare/accounts/{accountName}/shareSubscriptions/{shareSubscriptionName}/dataSetMappings/{dataSetMappingName}
 * ```
 * @property accountName The name of the share account.
 * @property dataSetId The id of the source data set.
 * @property dataSetMappingName The name of the data set mapping to be created.
 * @property kind Kind of data set mapping.
 * Expected value is 'KustoTable'.
 * @property kustoClusterResourceId Resource id of the sink kusto cluster.
 * @property resourceGroupName The resource group name.
 * @property shareSubscriptionName The name of the share subscription which will hold the data set sink.
 */
public data class KustoTableDataSetMappingArgs(
    public val accountName: Output<String>? = null,
    public val dataSetId: Output<String>? = null,
    public val dataSetMappingName: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val kustoClusterResourceId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val shareSubscriptionName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datashare.KustoTableDataSetMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.datashare.KustoTableDataSetMappingArgs =
        com.pulumi.azurenative.datashare.KustoTableDataSetMappingArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .dataSetId(dataSetId?.applyValue({ args0 -> args0 }))
            .dataSetMappingName(dataSetMappingName?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .kustoClusterResourceId(kustoClusterResourceId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .shareSubscriptionName(shareSubscriptionName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KustoTableDataSetMappingArgs].
 */
@PulumiTagMarker
public class KustoTableDataSetMappingArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var dataSetId: Output<String>? = null

    private var dataSetMappingName: Output<String>? = null

    private var kind: Output<String>? = null

    private var kustoClusterResourceId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var shareSubscriptionName: Output<String>? = null

    /**
     * @param value The name of the share account.
     */
    @JvmName("jxnbrjxyeagcuwdv")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The id of the source data set.
     */
    @JvmName("rporfanppfkvdldo")
    public suspend fun dataSetId(`value`: Output<String>) {
        this.dataSetId = value
    }

    /**
     * @param value The name of the data set mapping to be created.
     */
    @JvmName("inetnknmafwbbgpk")
    public suspend fun dataSetMappingName(`value`: Output<String>) {
        this.dataSetMappingName = value
    }

    /**
     * @param value Kind of data set mapping.
     * Expected value is 'KustoTable'.
     */
    @JvmName("neikjrqiqdiaocjo")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Resource id of the sink kusto cluster.
     */
    @JvmName("ynomwrdxsiqcpbic")
    public suspend fun kustoClusterResourceId(`value`: Output<String>) {
        this.kustoClusterResourceId = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("jhnigcdnvjfwapkc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the share subscription which will hold the data set sink.
     */
    @JvmName("yryrktgombcljavm")
    public suspend fun shareSubscriptionName(`value`: Output<String>) {
        this.shareSubscriptionName = value
    }

    /**
     * @param value The name of the share account.
     */
    @JvmName("ogihajupostqofsv")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The id of the source data set.
     */
    @JvmName("qobxtndygshobkki")
    public suspend fun dataSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetId = mapped
    }

    /**
     * @param value The name of the data set mapping to be created.
     */
    @JvmName("eujmmwdbwmgaldau")
    public suspend fun dataSetMappingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetMappingName = mapped
    }

    /**
     * @param value Kind of data set mapping.
     * Expected value is 'KustoTable'.
     */
    @JvmName("lycysyypureslyxr")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Resource id of the sink kusto cluster.
     */
    @JvmName("tlribwtlbepeviky")
    public suspend fun kustoClusterResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kustoClusterResourceId = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("lhfjdlxpulsupyrd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the share subscription which will hold the data set sink.
     */
    @JvmName("myhbymsygnlagxyb")
    public suspend fun shareSubscriptionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareSubscriptionName = mapped
    }

    internal fun build(): KustoTableDataSetMappingArgs = KustoTableDataSetMappingArgs(
        accountName = accountName,
        dataSetId = dataSetId,
        dataSetMappingName = dataSetMappingName,
        kind = kind,
        kustoClusterResourceId = kustoClusterResourceId,
        resourceGroupName = resourceGroupName,
        shareSubscriptionName = shareSubscriptionName,
    )
}
