@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A Invitation data transfer object.
 * @property expirationDate The expiration date for the invitation and share subscription.
 * @property id The resource id of the azure resource
 * @property invitationId unique invitation id
 * @property invitationStatus The status of the invitation.
 * @property name Name of the azure resource
 * @property respondedAt The time the recipient responded to the invitation.
 * @property sentAt Gets the time at which the invitation was sent.
 * @property systemData System Data of the Azure resource.
 * @property targetActiveDirectoryId The target Azure AD Id. Can't be combined with email.
 * @property targetEmail The email the invitation is directed to.
 * @property targetObjectId The target user or application Id that invitation is being sent to.
 * Must be specified along TargetActiveDirectoryId. This enables sending
 * invitations to specific users or applications in an AD tenant.
 * @property type Type of the azure resource
 * @property userEmail Email of the user who created the resource
 * @property userName Name of the user who created the resource
 */
public data class GetInvitationResult(
    public val expirationDate: String? = null,
    public val id: String,
    public val invitationId: String,
    public val invitationStatus: String,
    public val name: String,
    public val respondedAt: String,
    public val sentAt: String,
    public val systemData: SystemDataResponse,
    public val targetActiveDirectoryId: String? = null,
    public val targetEmail: String? = null,
    public val targetObjectId: String? = null,
    public val type: String,
    public val userEmail: String,
    public val userName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datashare.outputs.GetInvitationResult):
            GetInvitationResult = GetInvitationResult(
            expirationDate = javaType.expirationDate().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            invitationId = javaType.invitationId(),
            invitationStatus = javaType.invitationStatus(),
            name = javaType.name(),
            respondedAt = javaType.respondedAt(),
            sentAt = javaType.sentAt(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            targetActiveDirectoryId = javaType.targetActiveDirectoryId().map({ args0 -> args0 }).orElse(null),
            targetEmail = javaType.targetEmail().map({ args0 -> args0 }).orElse(null),
            targetObjectId = javaType.targetObjectId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            userEmail = javaType.userEmail(),
            userName = javaType.userName(),
        )
    }
}
