@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A Synapse Workspace Sql Pool Table data set.
 * @property dataSetId Unique id for identifying a data set resource
 * @property id The resource id of the azure resource
 * @property kind Kind of data set.
 * Expected value is 'SynapseWorkspaceSqlPoolTable'.
 * @property name Name of the azure resource
 * @property synapseWorkspaceSqlPoolTableResourceId Resource id of the Synapse Workspace SQL Pool Table
 * @property systemData System Data of the Azure resource.
 * @property type Type of the azure resource
 */
public data class GetSynapseWorkspaceSqlPoolTableDataSetResult(
    public val dataSetId: String,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val synapseWorkspaceSqlPoolTableResourceId: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datashare.outputs.GetSynapseWorkspaceSqlPoolTableDataSetResult):
            GetSynapseWorkspaceSqlPoolTableDataSetResult = GetSynapseWorkspaceSqlPoolTableDataSetResult(
            dataSetId = javaType.dataSetId(),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            synapseWorkspaceSqlPoolTableResourceId = javaType.synapseWorkspaceSqlPoolTableResourceId(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
