@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin

import com.pulumi.azurenative.dbformariadb.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.dbformariadb.kotlin.inputs.PrivateEndpointPropertyArgs
import com.pulumi.azurenative.dbformariadb.kotlin.inputs.PrivateEndpointPropertyArgsBuilder
import com.pulumi.azurenative.dbformariadb.kotlin.inputs.PrivateLinkServiceConnectionStatePropertyArgs
import com.pulumi.azurenative.dbformariadb.kotlin.inputs.PrivateLinkServiceConnectionStatePropertyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A private endpoint connection
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * Other available API versions: 2018-06-01-privatepreview.
 * ## Example Usage
 * ### Approve or reject a private endpoint connection with a given name.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.DBforMariaDB.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         PrivateEndpointConnectionName = "private-endpoint-connection-name",
 *         PrivateLinkServiceConnectionState = new AzureNative.DBforMariaDB.Inputs.PrivateLinkServiceConnectionStatePropertyArgs
 *         {
 *             Description = "Approved by johndoe@contoso.com",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "Default",
 *         ServerName = "test-svr",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbformariadb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbformariadb.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &dbformariadb.PrivateEndpointConnectionArgs{
 * 			PrivateEndpointConnectionName: pulumi.String("private-endpoint-connection-name"),
 * 			PrivateLinkServiceConnectionState: &dbformariadb.PrivateLinkServiceConnectionStatePropertyArgs{
 * 				Description: pulumi.String("Approved by johndoe@contoso.com"),
 * 				Status:      pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("Default"),
 * 			ServerName:        pulumi.String("test-svr"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbformariadb.PrivateEndpointConnection;
 * import com.pulumi.azurenative.dbformariadb.PrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .privateEndpointConnectionName("private-endpoint-connection-name")
 *             .privateLinkServiceConnectionState(Map.ofEntries(
 *                 Map.entry("description", "Approved by johndoe@contoso.com"),
 *                 Map.entry("status", "Approved")
 *             ))
 *             .resourceGroupName("Default")
 *             .serverName("test-svr")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbformariadb:PrivateEndpointConnection private-endpoint-connection-name /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMariaDB/servers/{serverName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property privateEndpoint Private endpoint which the connection belongs to.
 * @property privateEndpointConnectionName
 * @property privateLinkServiceConnectionState Connection state of the private endpoint connection.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serverName The name of the server.
 */
public data class PrivateEndpointConnectionArgs(
    public val privateEndpoint: Output<PrivateEndpointPropertyArgs>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState:
    Output<PrivateLinkServiceConnectionStatePropertyArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbformariadb.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.dbformariadb.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.dbformariadb.PrivateEndpointConnectionArgs.builder()
            .privateEndpoint(privateEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var privateEndpoint: Output<PrivateEndpointPropertyArgs>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState:
        Output<PrivateLinkServiceConnectionStatePropertyArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    /**
     * @param value Private endpoint which the connection belongs to.
     */
    @JvmName("mcensbxenjyajjbr")
    public suspend fun privateEndpoint(`value`: Output<PrivateEndpointPropertyArgs>) {
        this.privateEndpoint = value
    }

    /**
     * @param value
     */
    @JvmName("wdffqogewiqjmyql")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value Connection state of the private endpoint connection.
     */
    @JvmName("gnmhyngnaigbibqp")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStatePropertyArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mfuvwtwagolbrtty")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("oslbtwjqeuukbvip")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value Private endpoint which the connection belongs to.
     */
    @JvmName("vqjvtnywdumhqkih")
    public suspend fun privateEndpoint(`value`: PrivateEndpointPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpoint = mapped
    }

    /**
     * @param argument Private endpoint which the connection belongs to.
     */
    @JvmName("yanqkxnqtqsaipea")
    public suspend
    fun privateEndpoint(argument: suspend PrivateEndpointPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateEndpoint = mapped
    }

    /**
     * @param value
     */
    @JvmName("mmflllheqehbvcor")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value Connection state of the private endpoint connection.
     */
    @JvmName("roatfwowtoijtmfd")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStatePropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument Connection state of the private endpoint connection.
     */
    @JvmName("kxvyytwxymuthlps")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStatePropertyArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStatePropertyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hyssccynffqhjjbq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("waxbfgufrosccrrw")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        privateEndpoint = privateEndpoint,
        privateEndpointConnectionName = privateEndpointConnectionName,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
    )
}
