@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin.inputs

import com.pulumi.azurenative.dbformariadb.inputs.GetFirewallRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property firewallRuleName The name of the server firewall rule.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serverName The name of the server.
 */
public data class GetFirewallRulePlainArgs(
    public val firewallRuleName: String,
    public val resourceGroupName: String,
    public val serverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.dbformariadb.inputs.GetFirewallRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.dbformariadb.inputs.GetFirewallRulePlainArgs =
        com.pulumi.azurenative.dbformariadb.inputs.GetFirewallRulePlainArgs.builder()
            .firewallRuleName(firewallRuleName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFirewallRulePlainArgs].
 */
@PulumiTagMarker
public class GetFirewallRulePlainArgsBuilder internal constructor() {
    private var firewallRuleName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    /**
     * @param value The name of the server firewall rule.
     */
    @JvmName("ufvktmlowgsgoqnx")
    public suspend fun firewallRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.firewallRuleName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("glipmctnsgviyscr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("opagawmtxpurbfme")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetFirewallRulePlainArgs = GetFirewallRulePlainArgs(
        firewallRuleName = firewallRuleName ?: throw PulumiNullFieldException("firewallRuleName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
    )
}
