@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin.inputs

import com.pulumi.azurenative.dbformariadb.inputs.GetVirtualNetworkRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serverName The name of the server.
 * @property virtualNetworkRuleName The name of the virtual network rule.
 */
public data class GetVirtualNetworkRulePlainArgs(
    public val resourceGroupName: String,
    public val serverName: String,
    public val virtualNetworkRuleName: String,
) : ConvertibleToJava<com.pulumi.azurenative.dbformariadb.inputs.GetVirtualNetworkRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.dbformariadb.inputs.GetVirtualNetworkRulePlainArgs =
        com.pulumi.azurenative.dbformariadb.inputs.GetVirtualNetworkRulePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 }))
            .virtualNetworkRuleName(virtualNetworkRuleName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualNetworkRulePlainArgs].
 */
@PulumiTagMarker
public class GetVirtualNetworkRulePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var serverName: String? = null

    private var virtualNetworkRuleName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("weymptickyfluukv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("xhhvnmrcfbgqvhtd")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    /**
     * @param value The name of the virtual network rule.
     */
    @JvmName("nwikridqylyetspf")
    public suspend fun virtualNetworkRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworkRuleName = mapped
    }

    internal fun build(): GetVirtualNetworkRulePlainArgs = GetVirtualNetworkRulePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
        virtualNetworkRuleName = virtualNetworkRuleName ?: throw
            PulumiNullFieldException("virtualNetworkRuleName"),
    )
}
