@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin.inputs

import com.pulumi.azurenative.dbformariadb.inputs.ServerPropertiesForRestoreArgs.builder
import com.pulumi.azurenative.dbformariadb.kotlin.enums.MinimalTlsVersionEnum
import com.pulumi.azurenative.dbformariadb.kotlin.enums.PublicNetworkAccessEnum
import com.pulumi.azurenative.dbformariadb.kotlin.enums.ServerVersion
import com.pulumi.azurenative.dbformariadb.kotlin.enums.SslEnforcementEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties used to create a new server by restoring from a backup.
 * @property createMode The mode to create a new server.
 * Expected value is 'PointInTimeRestore'.
 * @property minimalTlsVersion Enforce a minimal Tls version for the server.
 * @property publicNetworkAccess Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'
 * @property restorePointInTime Restore point creation time (ISO8601 format), specifying the time to restore from.
 * @property sourceServerId The source server id to restore from.
 * @property sslEnforcement Enable ssl enforcement or not when connect to server.
 * @property storageProfile Storage profile of a server.
 * @property version Server version.
 */
public data class ServerPropertiesForRestoreArgs(
    public val createMode: Output<String>,
    public val minimalTlsVersion: Output<Either<String, MinimalTlsVersionEnum>>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccessEnum>>? = null,
    public val restorePointInTime: Output<String>,
    public val sourceServerId: Output<String>,
    public val sslEnforcement: Output<SslEnforcementEnum>? = null,
    public val storageProfile: Output<StorageProfileArgs>? = null,
    public val version: Output<Either<String, ServerVersion>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbformariadb.inputs.ServerPropertiesForRestoreArgs> {
    override fun toJava(): com.pulumi.azurenative.dbformariadb.inputs.ServerPropertiesForRestoreArgs =
        com.pulumi.azurenative.dbformariadb.inputs.ServerPropertiesForRestoreArgs.builder()
            .createMode(createMode.applyValue({ args0 -> args0 }))
            .minimalTlsVersion(
                minimalTlsVersion?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .restorePointInTime(restorePointInTime.applyValue({ args0 -> args0 }))
            .sourceServerId(sourceServerId.applyValue({ args0 -> args0 }))
            .sslEnforcement(sslEnforcement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageProfile(storageProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .version(
                version?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ServerPropertiesForRestoreArgs].
 */
@PulumiTagMarker
public class ServerPropertiesForRestoreArgsBuilder internal constructor() {
    private var createMode: Output<String>? = null

    private var minimalTlsVersion: Output<Either<String, MinimalTlsVersionEnum>>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccessEnum>>? = null

    private var restorePointInTime: Output<String>? = null

    private var sourceServerId: Output<String>? = null

    private var sslEnforcement: Output<SslEnforcementEnum>? = null

    private var storageProfile: Output<StorageProfileArgs>? = null

    private var version: Output<Either<String, ServerVersion>>? = null

    /**
     * @param value The mode to create a new server.
     * Expected value is 'PointInTimeRestore'.
     */
    @JvmName("psbdjnotwvncudaa")
    public suspend fun createMode(`value`: Output<String>) {
        this.createMode = value
    }

    /**
     * @param value Enforce a minimal Tls version for the server.
     */
    @JvmName("psdwxaqaesyjeoij")
    public suspend fun minimalTlsVersion(`value`: Output<Either<String, MinimalTlsVersionEnum>>) {
        this.minimalTlsVersion = value
    }

    /**
     * @param value Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    @JvmName("gmeoqcmhiwhcjlsk")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccessEnum>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Restore point creation time (ISO8601 format), specifying the time to restore from.
     */
    @JvmName("urbposhjwuvdgrmx")
    public suspend fun restorePointInTime(`value`: Output<String>) {
        this.restorePointInTime = value
    }

    /**
     * @param value The source server id to restore from.
     */
    @JvmName("weshqxuujrojnbxc")
    public suspend fun sourceServerId(`value`: Output<String>) {
        this.sourceServerId = value
    }

    /**
     * @param value Enable ssl enforcement or not when connect to server.
     */
    @JvmName("wxkqpnsnwbolrpye")
    public suspend fun sslEnforcement(`value`: Output<SslEnforcementEnum>) {
        this.sslEnforcement = value
    }

    /**
     * @param value Storage profile of a server.
     */
    @JvmName("avlnfortwoxfilsv")
    public suspend fun storageProfile(`value`: Output<StorageProfileArgs>) {
        this.storageProfile = value
    }

    /**
     * @param value Server version.
     */
    @JvmName("wnoakoejnjdrqiww")
    public suspend fun version(`value`: Output<Either<String, ServerVersion>>) {
        this.version = value
    }

    /**
     * @param value The mode to create a new server.
     * Expected value is 'PointInTimeRestore'.
     */
    @JvmName("ajdskstcjwkaapfg")
    public suspend fun createMode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Enforce a minimal Tls version for the server.
     */
    @JvmName("csabbgmefgycacyh")
    public suspend fun minimalTlsVersion(`value`: Either<String, MinimalTlsVersionEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimalTlsVersion = mapped
    }

    /**
     * @param value Enforce a minimal Tls version for the server.
     */
    @JvmName("uosqccjlyhjoiexk")
    public fun minimalTlsVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MinimalTlsVersionEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimalTlsVersion = mapped
    }

    /**
     * @param value Enforce a minimal Tls version for the server.
     */
    @JvmName("bmhvnrgypssywkfn")
    public fun minimalTlsVersion(`value`: MinimalTlsVersionEnum) {
        val toBeMapped = Either.ofRight<String, MinimalTlsVersionEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimalTlsVersion = mapped
    }

    /**
     * @param value Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    @JvmName("stskammpnpqmmdgq")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccessEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    @JvmName("naiklhtesielngep")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccessEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    @JvmName("hcjxiagkjdkjfoad")
    public fun publicNetworkAccess(`value`: PublicNetworkAccessEnum) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccessEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Restore point creation time (ISO8601 format), specifying the time to restore from.
     */
    @JvmName("ersbutydstgtpqdg")
    public suspend fun restorePointInTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.restorePointInTime = mapped
    }

    /**
     * @param value The source server id to restore from.
     */
    @JvmName("xbxgstrnfcrmpuxj")
    public suspend fun sourceServerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceServerId = mapped
    }

    /**
     * @param value Enable ssl enforcement or not when connect to server.
     */
    @JvmName("ngorxhablitjhqme")
    public suspend fun sslEnforcement(`value`: SslEnforcementEnum?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslEnforcement = mapped
    }

    /**
     * @param value Storage profile of a server.
     */
    @JvmName("klshxkgipscxofah")
    public suspend fun storageProfile(`value`: StorageProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageProfile = mapped
    }

    /**
     * @param argument Storage profile of a server.
     */
    @JvmName("xxrxienqijqwgqaw")
    public suspend fun storageProfile(argument: suspend StorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = StorageProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageProfile = mapped
    }

    /**
     * @param value Server version.
     */
    @JvmName("biwuoxoyfdrvtbwu")
    public suspend fun version(`value`: Either<String, ServerVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value Server version.
     */
    @JvmName("yabdbpyrdmeukvrm")
    public fun version(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServerVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value Server version.
     */
    @JvmName("pymklgcegdsjdtsj")
    public fun version(`value`: ServerVersion) {
        val toBeMapped = Either.ofRight<String, ServerVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ServerPropertiesForRestoreArgs = ServerPropertiesForRestoreArgs(
        createMode = createMode ?: throw PulumiNullFieldException("createMode"),
        minimalTlsVersion = minimalTlsVersion,
        publicNetworkAccess = publicNetworkAccess,
        restorePointInTime = restorePointInTime ?: throw PulumiNullFieldException("restorePointInTime"),
        sourceServerId = sourceServerId ?: throw PulumiNullFieldException("sourceServerId"),
        sslEnforcement = sslEnforcement,
        storageProfile = storageProfile,
        version = version,
    )
}
