@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin

import com.pulumi.azurenative.dbformysql.AzureADAdministratorArgs.builder
import com.pulumi.azurenative.dbformysql.kotlin.enums.AdministratorType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a Administrator.
 * Azure REST API version: 2022-01-01.
 * Other available API versions: 2023-06-01-preview, 2023-06-30.
 * ## Example Usage
 * ### Create an azure ad administrator
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureADAdministrator = new AzureNative.DBforMySQL.AzureADAdministrator("azureADAdministrator", new()
 *     {
 *         AdministratorName = "ActiveDirectory",
 *         AdministratorType = "ActiveDirectory",
 *         IdentityResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/test-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-umi",
 *         Login = "bob@contoso.com",
 *         ResourceGroupName = "testrg",
 *         ServerName = "mysqltestsvc4",
 *         Sid = "c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c",
 *         TenantId = "c12b7025-bfe2-46c1-b463-993b5e4cd467",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbformysql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbformysql.NewAzureADAdministrator(ctx, "azureADAdministrator", &dbformysql.AzureADAdministratorArgs{
 * 			AdministratorName:  pulumi.String("ActiveDirectory"),
 * 			AdministratorType:  pulumi.String("ActiveDirectory"),
 * 			IdentityResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/test-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-umi"),
 * 			Login:              pulumi.String("bob@contoso.com"),
 * 			ResourceGroupName:  pulumi.String("testrg"),
 * 			ServerName:         pulumi.String("mysqltestsvc4"),
 * 			Sid:                pulumi.String("c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c"),
 * 			TenantId:           pulumi.String("c12b7025-bfe2-46c1-b463-993b5e4cd467"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbformysql.AzureADAdministrator;
 * import com.pulumi.azurenative.dbformysql.AzureADAdministratorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureADAdministrator = new AzureADAdministrator("azureADAdministrator", AzureADAdministratorArgs.builder()
 *             .administratorName("ActiveDirectory")
 *             .administratorType("ActiveDirectory")
 *             .identityResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/test-group/providers/Microsoft.ManagedIdentity/userAssignedIdentities/test-umi")
 *             .login("bob@contoso.com")
 *             .resourceGroupName("testrg")
 *             .serverName("mysqltestsvc4")
 *             .sid("c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c")
 *             .tenantId("c12b7025-bfe2-46c1-b463-993b5e4cd467")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbformysql:AzureADAdministrator ActiveDirectory /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/flexibleServers/{serverName}/administrators/{administratorName}
 * ```
 * @property administratorName The name of the Azure AD Administrator.
 * @property administratorType Type of the sever administrator.
 * @property identityResourceId The resource id of the identity used for AAD Authentication.
 * @property login Login name of the server administrator.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serverName The name of the server.
 * @property sid SID (object ID) of the server administrator.
 * @property tenantId Tenant ID of the administrator.
 */
public data class AzureADAdministratorArgs(
    public val administratorName: Output<String>? = null,
    public val administratorType: Output<Either<String, AdministratorType>>? = null,
    public val identityResourceId: Output<String>? = null,
    public val login: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val sid: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbformysql.AzureADAdministratorArgs> {
    override fun toJava(): com.pulumi.azurenative.dbformysql.AzureADAdministratorArgs =
        com.pulumi.azurenative.dbformysql.AzureADAdministratorArgs.builder()
            .administratorName(administratorName?.applyValue({ args0 -> args0 }))
            .administratorType(
                administratorType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .identityResourceId(identityResourceId?.applyValue({ args0 -> args0 }))
            .login(login?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .sid(sid?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureADAdministratorArgs].
 */
@PulumiTagMarker
public class AzureADAdministratorArgsBuilder internal constructor() {
    private var administratorName: Output<String>? = null

    private var administratorType: Output<Either<String, AdministratorType>>? = null

    private var identityResourceId: Output<String>? = null

    private var login: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var sid: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value The name of the Azure AD Administrator.
     */
    @JvmName("eplvtmcmavhwbqij")
    public suspend fun administratorName(`value`: Output<String>) {
        this.administratorName = value
    }

    /**
     * @param value Type of the sever administrator.
     */
    @JvmName("emtejcpvniwnhmen")
    public suspend fun administratorType(`value`: Output<Either<String, AdministratorType>>) {
        this.administratorType = value
    }

    /**
     * @param value The resource id of the identity used for AAD Authentication.
     */
    @JvmName("kvlgejhhgblhhujn")
    public suspend fun identityResourceId(`value`: Output<String>) {
        this.identityResourceId = value
    }

    /**
     * @param value Login name of the server administrator.
     */
    @JvmName("alwkyrsqbqrlgvpj")
    public suspend fun login(`value`: Output<String>) {
        this.login = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qkixguowsyjccavj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("rdcenitnehlpwgev")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value SID (object ID) of the server administrator.
     */
    @JvmName("mnevqwqhuixkctox")
    public suspend fun sid(`value`: Output<String>) {
        this.sid = value
    }

    /**
     * @param value Tenant ID of the administrator.
     */
    @JvmName("cfuibeirffrdbbfw")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value The name of the Azure AD Administrator.
     */
    @JvmName("iovvdubuoxnddjnj")
    public suspend fun administratorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorName = mapped
    }

    /**
     * @param value Type of the sever administrator.
     */
    @JvmName("mehwqedyuofdkqnn")
    public suspend fun administratorType(`value`: Either<String, AdministratorType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorType = mapped
    }

    /**
     * @param value Type of the sever administrator.
     */
    @JvmName("swyfbelgbxnagmvj")
    public fun administratorType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AdministratorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.administratorType = mapped
    }

    /**
     * @param value Type of the sever administrator.
     */
    @JvmName("wdmkdvyfwahantup")
    public fun administratorType(`value`: AdministratorType) {
        val toBeMapped = Either.ofRight<String, AdministratorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.administratorType = mapped
    }

    /**
     * @param value The resource id of the identity used for AAD Authentication.
     */
    @JvmName("jodcmxjuerejhryq")
    public suspend fun identityResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityResourceId = mapped
    }

    /**
     * @param value Login name of the server administrator.
     */
    @JvmName("gvbyjstryxywwubv")
    public suspend fun login(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.login = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jfgmnbqvdclgtjyr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("ujhpdcvdiurabrye")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value SID (object ID) of the server administrator.
     */
    @JvmName("guvrajmyatttcdnu")
    public suspend fun sid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sid = mapped
    }

    /**
     * @param value Tenant ID of the administrator.
     */
    @JvmName("gpcvopyktlwixiex")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): AzureADAdministratorArgs = AzureADAdministratorArgs(
        administratorName = administratorName,
        administratorType = administratorType,
        identityResourceId = identityResourceId,
        login = login,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        sid = sid,
        tenantId = tenantId,
    )
}
