@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin

import com.pulumi.azurenative.dbformysql.ServerArgs.builder
import com.pulumi.azurenative.dbformysql.kotlin.enums.CreateMode
import com.pulumi.azurenative.dbformysql.kotlin.enums.ReplicationRole
import com.pulumi.azurenative.dbformysql.kotlin.enums.ServerVersion
import com.pulumi.azurenative.dbformysql.kotlin.inputs.BackupArgs
import com.pulumi.azurenative.dbformysql.kotlin.inputs.BackupArgsBuilder
import com.pulumi.azurenative.dbformysql.kotlin.inputs.DataEncryptionArgs
import com.pulumi.azurenative.dbformysql.kotlin.inputs.DataEncryptionArgsBuilder
import com.pulumi.azurenative.dbformysql.kotlin.inputs.HighAvailabilityArgs
import com.pulumi.azurenative.dbformysql.kotlin.inputs.HighAvailabilityArgsBuilder
import com.pulumi.azurenative.dbformysql.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.dbformysql.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.dbformysql.kotlin.inputs.MaintenanceWindowArgs
import com.pulumi.azurenative.dbformysql.kotlin.inputs.MaintenanceWindowArgsBuilder
import com.pulumi.azurenative.dbformysql.kotlin.inputs.NetworkArgs
import com.pulumi.azurenative.dbformysql.kotlin.inputs.NetworkArgsBuilder
import com.pulumi.azurenative.dbformysql.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.dbformysql.kotlin.inputs.SkuArgsBuilder
import com.pulumi.azurenative.dbformysql.kotlin.inputs.StorageArgs
import com.pulumi.azurenative.dbformysql.kotlin.inputs.StorageArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents a server.
 * Azure REST API version: 2022-01-01. Prior API version in Azure Native 1.x: 2017-12-01.
 * Other available API versions: 2017-12-01, 2018-06-01-privatepreview, 2020-07-01-preview, 2020-07-01-privatepreview, 2022-09-30-preview, 2023-06-01-preview, 2023-06-30, 2023-10-01-preview.
 * ## Example Usage
 * ### Create a new server
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforMySQL.Server("server", new()
 *     {
 *         AdministratorLogin = "cloudsa",
 *         AdministratorLoginPassword = "your_password",
 *         AvailabilityZone = "1",
 *         Backup = new AzureNative.DBforMySQL.Inputs.BackupArgs
 *         {
 *             BackupRetentionDays = 7,
 *             GeoRedundantBackup = "Disabled",
 *         },
 *         CreateMode = "Default",
 *         HighAvailability = new AzureNative.DBforMySQL.Inputs.HighAvailabilityArgs
 *         {
 *             Mode = "ZoneRedundant",
 *             StandbyAvailabilityZone = "3",
 *         },
 *         Location = "southeastasia",
 *         ResourceGroupName = "testrg",
 *         ServerName = "mysqltestserver",
 *         Sku = new AzureNative.DBforMySQL.Inputs.SkuArgs
 *         {
 *             Name = "Standard_D2ds_v4",
 *             Tier = "GeneralPurpose",
 *         },
 *         Storage = new AzureNative.DBforMySQL.Inputs.StorageArgs
 *         {
 *             AutoGrow = "Disabled",
 *             Iops = 600,
 *             StorageSizeGB = 100,
 *         },
 *         Tags =
 *         {
 *             { "num", "1" },
 *         },
 *         Version = "5.7",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbformysql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbformysql.NewServer(ctx, "server", &dbformysql.ServerArgs{
 * 			AdministratorLogin:         pulumi.String("cloudsa"),
 * 			AdministratorLoginPassword: pulumi.String("your_password"),
 * 			AvailabilityZone:           pulumi.String("1"),
 * 			Backup: &dbformysql.BackupArgs{
 * 				BackupRetentionDays: pulumi.Int(7),
 * 				GeoRedundantBackup:  pulumi.String("Disabled"),
 * 			},
 * 			CreateMode: pulumi.String("Default"),
 * 			HighAvailability: &dbformysql.HighAvailabilityArgs{
 * 				Mode:                    pulumi.String("ZoneRedundant"),
 * 				StandbyAvailabilityZone: pulumi.String("3"),
 * 			},
 * 			Location:          pulumi.String("southeastasia"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			ServerName:        pulumi.String("mysqltestserver"),
 * 			Sku: &dbformysql.SkuArgs{
 * 				Name: pulumi.String("Standard_D2ds_v4"),
 * 				Tier: pulumi.String("GeneralPurpose"),
 * 			},
 * 			Storage: &dbformysql.StorageArgs{
 * 				AutoGrow:      pulumi.String("Disabled"),
 * 				Iops:          pulumi.Int(600),
 * 				StorageSizeGB: pulumi.Int(100),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"num": pulumi.String("1"),
 * 			},
 * 			Version: pulumi.String("5.7"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbformysql.Server;
 * import com.pulumi.azurenative.dbformysql.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .administratorLogin("cloudsa")
 *             .administratorLoginPassword("your_password")
 *             .availabilityZone("1")
 *             .backup(Map.ofEntries(
 *                 Map.entry("backupRetentionDays", 7),
 *                 Map.entry("geoRedundantBackup", "Disabled")
 *             ))
 *             .createMode("Default")
 *             .highAvailability(Map.ofEntries(
 *                 Map.entry("mode", "ZoneRedundant"),
 *                 Map.entry("standbyAvailabilityZone", "3")
 *             ))
 *             .location("southeastasia")
 *             .resourceGroupName("testrg")
 *             .serverName("mysqltestserver")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Standard_D2ds_v4"),
 *                 Map.entry("tier", "GeneralPurpose")
 *             ))
 *             .storage(Map.ofEntries(
 *                 Map.entry("autoGrow", "Disabled"),
 *                 Map.entry("iops", 600),
 *                 Map.entry("storageSizeGB", 100)
 *             ))
 *             .tags(Map.of("num", "1"))
 *             .version("5.7")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a replica server
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforMySQL.Server("server", new()
 *     {
 *         CreateMode = "Replica",
 *         Location = "SoutheastAsia",
 *         ResourceGroupName = "testgr",
 *         ServerName = "replica-server",
 *         SourceServerResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testgr/providers/Microsoft.DBforMySQL/flexibleServers/source-server",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbformysql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbformysql.NewServer(ctx, "server", &dbformysql.ServerArgs{
 * 			CreateMode:             pulumi.String("Replica"),
 * 			Location:               pulumi.String("SoutheastAsia"),
 * 			ResourceGroupName:      pulumi.String("testgr"),
 * 			ServerName:             pulumi.String("replica-server"),
 * 			SourceServerResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testgr/providers/Microsoft.DBforMySQL/flexibleServers/source-server"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbformysql.Server;
 * import com.pulumi.azurenative.dbformysql.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .createMode("Replica")
 *             .location("SoutheastAsia")
 *             .resourceGroupName("testgr")
 *             .serverName("replica-server")
 *             .sourceServerResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/testgr/providers/Microsoft.DBforMySQL/flexibleServers/source-server")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a server as a point in time restore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var server = new AzureNative.DBforMySQL.Server("server", new()
 *     {
 *         CreateMode = "PointInTimeRestore",
 *         Location = "SoutheastAsia",
 *         ResourceGroupName = "TargetResourceGroup",
 *         RestorePointInTime = "2021-06-24T00:00:37.467Z",
 *         ServerName = "targetserver",
 *         Sku = new AzureNative.DBforMySQL.Inputs.SkuArgs
 *         {
 *             Name = "Standard_D14_v2",
 *             Tier = "GeneralPurpose",
 *         },
 *         SourceServerResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/SourceResourceGroup/providers/Microsoft.DBforMySQL/flexibleServers/sourceserver",
 *         Tags =
 *         {
 *             { "num", "1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbformysql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbformysql.NewServer(ctx, "server", &dbformysql.ServerArgs{
 * 			CreateMode:         pulumi.String("PointInTimeRestore"),
 * 			Location:           pulumi.String("SoutheastAsia"),
 * 			ResourceGroupName:  pulumi.String("TargetResourceGroup"),
 * 			RestorePointInTime: pulumi.String("2021-06-24T00:00:37.467Z"),
 * 			ServerName:         pulumi.String("targetserver"),
 * 			Sku: &dbformysql.SkuArgs{
 * 				Name: pulumi.String("Standard_D14_v2"),
 * 				Tier: pulumi.String("GeneralPurpose"),
 * 			},
 * 			SourceServerResourceId: pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/SourceResourceGroup/providers/Microsoft.DBforMySQL/flexibleServers/sourceserver"),
 * 			Tags: pulumi.StringMap{
 * 				"num": pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbformysql.Server;
 * import com.pulumi.azurenative.dbformysql.ServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var server = new Server("server", ServerArgs.builder()
 *             .createMode("PointInTimeRestore")
 *             .location("SoutheastAsia")
 *             .resourceGroupName("TargetResourceGroup")
 *             .restorePointInTime("2021-06-24T00:00:37.467Z")
 *             .serverName("targetserver")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Standard_D14_v2"),
 *                 Map.entry("tier", "GeneralPurpose")
 *             ))
 *             .sourceServerResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/SourceResourceGroup/providers/Microsoft.DBforMySQL/flexibleServers/sourceserver")
 *             .tags(Map.of("num", "1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbformysql:Server mysqltestserver /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMySQL/flexibleServers/{serverName}
 * ```
 * @property administratorLogin The administrator's login name of a server. Can only be specified when the server is being created (and is required for creation).
 * @property administratorLoginPassword The password of the administrator login (required for server creation).
 * @property availabilityZone availability Zone information of the server.
 * @property backup Backup related properties of a server.
 * @property createMode The mode to create a new MySQL server.
 * @property dataEncryption The Data Encryption for CMK.
 * @property highAvailability High availability related properties of a server.
 * @property identity The cmk identity for the server.
 * @property location The geo-location where the resource lives
 * @property maintenanceWindow Maintenance window of a server.
 * @property network Network related properties of a server.
 * @property replicationRole The replication role.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property restorePointInTime Restore point creation time (ISO8601 format), specifying the time to restore from.
 * @property serverName The name of the server.
 * @property sku The SKU (pricing tier) of the server.
 * @property sourceServerResourceId The source MySQL server id.
 * @property storage Storage related properties of a server.
 * @property tags Resource tags.
 * @property version Server version.
 */
public data class ServerArgs(
    public val administratorLogin: Output<String>? = null,
    public val administratorLoginPassword: Output<String>? = null,
    public val availabilityZone: Output<String>? = null,
    public val backup: Output<BackupArgs>? = null,
    public val createMode: Output<Either<String, CreateMode>>? = null,
    public val dataEncryption: Output<DataEncryptionArgs>? = null,
    public val highAvailability: Output<HighAvailabilityArgs>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val maintenanceWindow: Output<MaintenanceWindowArgs>? = null,
    public val network: Output<NetworkArgs>? = null,
    public val replicationRole: Output<Either<String, ReplicationRole>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val restorePointInTime: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val sourceServerResourceId: Output<String>? = null,
    public val storage: Output<StorageArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val version: Output<Either<String, ServerVersion>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbformysql.ServerArgs> {
    override fun toJava(): com.pulumi.azurenative.dbformysql.ServerArgs =
        com.pulumi.azurenative.dbformysql.ServerArgs.builder()
            .administratorLogin(administratorLogin?.applyValue({ args0 -> args0 }))
            .administratorLoginPassword(administratorLoginPassword?.applyValue({ args0 -> args0 }))
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .backup(backup?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .createMode(
                createMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dataEncryption(dataEncryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .highAvailability(highAvailability?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .maintenanceWindow(maintenanceWindow?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .network(network?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .replicationRole(
                replicationRole?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .restorePointInTime(restorePointInTime?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceServerResourceId(sourceServerResourceId?.applyValue({ args0 -> args0 }))
            .storage(storage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .version(
                version?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ServerArgs].
 */
@PulumiTagMarker
public class ServerArgsBuilder internal constructor() {
    private var administratorLogin: Output<String>? = null

    private var administratorLoginPassword: Output<String>? = null

    private var availabilityZone: Output<String>? = null

    private var backup: Output<BackupArgs>? = null

    private var createMode: Output<Either<String, CreateMode>>? = null

    private var dataEncryption: Output<DataEncryptionArgs>? = null

    private var highAvailability: Output<HighAvailabilityArgs>? = null

    private var identity: Output<IdentityArgs>? = null

    private var location: Output<String>? = null

    private var maintenanceWindow: Output<MaintenanceWindowArgs>? = null

    private var network: Output<NetworkArgs>? = null

    private var replicationRole: Output<Either<String, ReplicationRole>>? = null

    private var resourceGroupName: Output<String>? = null

    private var restorePointInTime: Output<String>? = null

    private var serverName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var sourceServerResourceId: Output<String>? = null

    private var storage: Output<StorageArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var version: Output<Either<String, ServerVersion>>? = null

    /**
     * @param value The administrator's login name of a server. Can only be specified when the server is being created (and is required for creation).
     */
    @JvmName("cteukcgormfkttoe")
    public suspend fun administratorLogin(`value`: Output<String>) {
        this.administratorLogin = value
    }

    /**
     * @param value The password of the administrator login (required for server creation).
     */
    @JvmName("kemktmkscvurdqtr")
    public suspend fun administratorLoginPassword(`value`: Output<String>) {
        this.administratorLoginPassword = value
    }

    /**
     * @param value availability Zone information of the server.
     */
    @JvmName("pyoykgnmkavbwwbu")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value Backup related properties of a server.
     */
    @JvmName("lktyawxwejtslrtc")
    public suspend fun backup(`value`: Output<BackupArgs>) {
        this.backup = value
    }

    /**
     * @param value The mode to create a new MySQL server.
     */
    @JvmName("banvjppoiouhnqol")
    public suspend fun createMode(`value`: Output<Either<String, CreateMode>>) {
        this.createMode = value
    }

    /**
     * @param value The Data Encryption for CMK.
     */
    @JvmName("swwnhcluusjhrbls")
    public suspend fun dataEncryption(`value`: Output<DataEncryptionArgs>) {
        this.dataEncryption = value
    }

    /**
     * @param value High availability related properties of a server.
     */
    @JvmName("ogwxhgnusgbmqsif")
    public suspend fun highAvailability(`value`: Output<HighAvailabilityArgs>) {
        this.highAvailability = value
    }

    /**
     * @param value The cmk identity for the server.
     */
    @JvmName("uayywbrxqdwkfspn")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("yciimqpqcldjcpjs")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Maintenance window of a server.
     */
    @JvmName("ihvrtqlodtkspsve")
    public suspend fun maintenanceWindow(`value`: Output<MaintenanceWindowArgs>) {
        this.maintenanceWindow = value
    }

    /**
     * @param value Network related properties of a server.
     */
    @JvmName("htehqlcmbfilltii")
    public suspend fun network(`value`: Output<NetworkArgs>) {
        this.network = value
    }

    /**
     * @param value The replication role.
     */
    @JvmName("vyeqpirvitbgwket")
    public suspend fun replicationRole(`value`: Output<Either<String, ReplicationRole>>) {
        this.replicationRole = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vsbkcnpicmbbgccn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Restore point creation time (ISO8601 format), specifying the time to restore from.
     */
    @JvmName("nrbvbcieivbauteo")
    public suspend fun restorePointInTime(`value`: Output<String>) {
        this.restorePointInTime = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("obdwqefivjymkaxr")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The SKU (pricing tier) of the server.
     */
    @JvmName("gbdkrkytelayhcfh")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The source MySQL server id.
     */
    @JvmName("pfeeipvlveucrbwm")
    public suspend fun sourceServerResourceId(`value`: Output<String>) {
        this.sourceServerResourceId = value
    }

    /**
     * @param value Storage related properties of a server.
     */
    @JvmName("rksgpganrqjihkjt")
    public suspend fun storage(`value`: Output<StorageArgs>) {
        this.storage = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("aidubnxysjhgggpd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Server version.
     */
    @JvmName("vcbwwxfqynprpjue")
    public suspend fun version(`value`: Output<Either<String, ServerVersion>>) {
        this.version = value
    }

    /**
     * @param value The administrator's login name of a server. Can only be specified when the server is being created (and is required for creation).
     */
    @JvmName("rbssgccigikdkckk")
    public suspend fun administratorLogin(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorLogin = mapped
    }

    /**
     * @param value The password of the administrator login (required for server creation).
     */
    @JvmName("otcxekcnclilevmi")
    public suspend fun administratorLoginPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorLoginPassword = mapped
    }

    /**
     * @param value availability Zone information of the server.
     */
    @JvmName("ihjooeanresyiqvj")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value Backup related properties of a server.
     */
    @JvmName("aggnpjjfesufxwdd")
    public suspend fun backup(`value`: BackupArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backup = mapped
    }

    /**
     * @param argument Backup related properties of a server.
     */
    @JvmName("xrxxwsxajbfbkuhc")
    public suspend fun backup(argument: suspend BackupArgsBuilder.() -> Unit) {
        val toBeMapped = BackupArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backup = mapped
    }

    /**
     * @param value The mode to create a new MySQL server.
     */
    @JvmName("hbiamhoimnowewau")
    public suspend fun createMode(`value`: Either<String, CreateMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value The mode to create a new MySQL server.
     */
    @JvmName("tkwfwgtcvxtijwwi")
    public fun createMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value The mode to create a new MySQL server.
     */
    @JvmName("gudvpefvfplxikfo")
    public fun createMode(`value`: CreateMode) {
        val toBeMapped = Either.ofRight<String, CreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value The Data Encryption for CMK.
     */
    @JvmName("quaexiiswmigvdmx")
    public suspend fun dataEncryption(`value`: DataEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataEncryption = mapped
    }

    /**
     * @param argument The Data Encryption for CMK.
     */
    @JvmName("ekmstqthlktbehfh")
    public suspend fun dataEncryption(argument: suspend DataEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = DataEncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataEncryption = mapped
    }

    /**
     * @param value High availability related properties of a server.
     */
    @JvmName("hsjxaomaabhblwsd")
    public suspend fun highAvailability(`value`: HighAvailabilityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.highAvailability = mapped
    }

    /**
     * @param argument High availability related properties of a server.
     */
    @JvmName("rvgxxitxpivicsow")
    public suspend fun highAvailability(argument: suspend HighAvailabilityArgsBuilder.() -> Unit) {
        val toBeMapped = HighAvailabilityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.highAvailability = mapped
    }

    /**
     * @param value The cmk identity for the server.
     */
    @JvmName("fvhgaasrecygfrms")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The cmk identity for the server.
     */
    @JvmName("huwowljwpcqfbrtr")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jugencdcaouyfsts")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Maintenance window of a server.
     */
    @JvmName("caqgvlpsaadkjrys")
    public suspend fun maintenanceWindow(`value`: MaintenanceWindowArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceWindow = mapped
    }

    /**
     * @param argument Maintenance window of a server.
     */
    @JvmName("cujxqgnkdhckpqie")
    public suspend fun maintenanceWindow(argument: suspend MaintenanceWindowArgsBuilder.() -> Unit) {
        val toBeMapped = MaintenanceWindowArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.maintenanceWindow = mapped
    }

    /**
     * @param value Network related properties of a server.
     */
    @JvmName("qxiyjpxanayyfelx")
    public suspend fun network(`value`: NetworkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.network = mapped
    }

    /**
     * @param argument Network related properties of a server.
     */
    @JvmName("fdqwdwiddvuthxqx")
    public suspend fun network(argument: suspend NetworkArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.network = mapped
    }

    /**
     * @param value The replication role.
     */
    @JvmName("pvpxaxhlqbuyvsaa")
    public suspend fun replicationRole(`value`: Either<String, ReplicationRole>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationRole = mapped
    }

    /**
     * @param value The replication role.
     */
    @JvmName("ipswvlnctpuvjwoq")
    public fun replicationRole(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReplicationRole>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicationRole = mapped
    }

    /**
     * @param value The replication role.
     */
    @JvmName("gsbejtlhjdlgvxbs")
    public fun replicationRole(`value`: ReplicationRole) {
        val toBeMapped = Either.ofRight<String, ReplicationRole>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicationRole = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hxntwpbqxhwsgdlj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Restore point creation time (ISO8601 format), specifying the time to restore from.
     */
    @JvmName("ctijkqalqdbrfsbt")
    public suspend fun restorePointInTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restorePointInTime = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("ekvhsrqmhsncuukf")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The SKU (pricing tier) of the server.
     */
    @JvmName("oxsfqnuvuqptythg")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU (pricing tier) of the server.
     */
    @JvmName("pkmvbmodocsfspsd")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The source MySQL server id.
     */
    @JvmName("abfffhglrboxckiw")
    public suspend fun sourceServerResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceServerResourceId = mapped
    }

    /**
     * @param value Storage related properties of a server.
     */
    @JvmName("junliorpcgkknggq")
    public suspend fun storage(`value`: StorageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storage = mapped
    }

    /**
     * @param argument Storage related properties of a server.
     */
    @JvmName("biybirswkvbywkkq")
    public suspend fun storage(argument: suspend StorageArgsBuilder.() -> Unit) {
        val toBeMapped = StorageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storage = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xqcioirswwsgevww")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nyxqgnktmubxkjsj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Server version.
     */
    @JvmName("qogyskqscbhbgkvs")
    public suspend fun version(`value`: Either<String, ServerVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value Server version.
     */
    @JvmName("jqumreuxhexotrga")
    public fun version(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServerVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value Server version.
     */
    @JvmName("qmwywqaenfdsfmqm")
    public fun version(`value`: ServerVersion) {
        val toBeMapped = Either.ofRight<String, ServerVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ServerArgs = ServerArgs(
        administratorLogin = administratorLogin,
        administratorLoginPassword = administratorLoginPassword,
        availabilityZone = availabilityZone,
        backup = backup,
        createMode = createMode,
        dataEncryption = dataEncryption,
        highAvailability = highAvailability,
        identity = identity,
        location = location,
        maintenanceWindow = maintenanceWindow,
        network = network,
        replicationRole = replicationRole,
        resourceGroupName = resourceGroupName,
        restorePointInTime = restorePointInTime,
        serverName = serverName,
        sku = sku,
        sourceServerResourceId = sourceServerResourceId,
        storage = storage,
        tags = tags,
        version = version,
    )
}
