@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin.inputs

import com.pulumi.azurenative.dbformysql.inputs.NetworkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Network related properties of a server
 * @property delegatedSubnetResourceId Delegated subnet resource id used to setup vnet for a server.
 * @property privateDnsZoneResourceId Private DNS zone resource id.
 */
public data class NetworkArgs(
    public val delegatedSubnetResourceId: Output<String>? = null,
    public val privateDnsZoneResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbformysql.inputs.NetworkArgs> {
    override fun toJava(): com.pulumi.azurenative.dbformysql.inputs.NetworkArgs =
        com.pulumi.azurenative.dbformysql.inputs.NetworkArgs.builder()
            .delegatedSubnetResourceId(delegatedSubnetResourceId?.applyValue({ args0 -> args0 }))
            .privateDnsZoneResourceId(privateDnsZoneResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkArgs].
 */
@PulumiTagMarker
public class NetworkArgsBuilder internal constructor() {
    private var delegatedSubnetResourceId: Output<String>? = null

    private var privateDnsZoneResourceId: Output<String>? = null

    /**
     * @param value Delegated subnet resource id used to setup vnet for a server.
     */
    @JvmName("gkimjhsbpbyyuvba")
    public suspend fun delegatedSubnetResourceId(`value`: Output<String>) {
        this.delegatedSubnetResourceId = value
    }

    /**
     * @param value Private DNS zone resource id.
     */
    @JvmName("jjbtbsgvrwqqoyrm")
    public suspend fun privateDnsZoneResourceId(`value`: Output<String>) {
        this.privateDnsZoneResourceId = value
    }

    /**
     * @param value Delegated subnet resource id used to setup vnet for a server.
     */
    @JvmName("pllkohmtwurfnyhi")
    public suspend fun delegatedSubnetResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delegatedSubnetResourceId = mapped
    }

    /**
     * @param value Private DNS zone resource id.
     */
    @JvmName("scapkkvqkdqdsbyv")
    public suspend fun privateDnsZoneResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateDnsZoneResourceId = mapped
    }

    internal fun build(): NetworkArgs = NetworkArgs(
        delegatedSubnetResourceId = delegatedSubnetResourceId,
        privateDnsZoneResourceId = privateDnsZoneResourceId,
    )
}
