@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a Administrator.
 * @property administratorType Type of the sever administrator.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identityResourceId The resource id of the identity used for AAD Authentication.
 * @property login Login name of the server administrator.
 * @property name The name of the resource
 * @property sid SID (object ID) of the server administrator.
 * @property systemData The system metadata relating to this resource.
 * @property tenantId Tenant ID of the administrator.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAzureADAdministratorResult(
    public val administratorType: String? = null,
    public val id: String,
    public val identityResourceId: String? = null,
    public val login: String? = null,
    public val name: String,
    public val sid: String? = null,
    public val systemData: SystemDataResponse,
    public val tenantId: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dbformysql.outputs.GetAzureADAdministratorResult):
            GetAzureADAdministratorResult = GetAzureADAdministratorResult(
            administratorType = javaType.administratorType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identityResourceId = javaType.identityResourceId().map({ args0 -> args0 }).orElse(null),
            login = javaType.login().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            sid = javaType.sid().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.dbformysql.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
