@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin

import com.pulumi.azurenative.dbforpostgresql.ClusterArgs.builder
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.MaintenanceWindowArgs
import com.pulumi.azurenative.dbforpostgresql.kotlin.inputs.MaintenanceWindowArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents a cluster.
 * Azure REST API version: 2022-11-08.
 * ## Example Usage
 * ### Create a new cluster as a point in time restore
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.DBforPostgreSQL.Cluster("cluster", new()
 *     {
 *         ClusterName = "testcluster",
 *         Location = "westus",
 *         PointInTimeUTC = "2017-12-14T00:00:37.467Z",
 *         ResourceGroupName = "TestGroup",
 *         SourceLocation = "westus",
 *         SourceResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/source-cluster",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewCluster(ctx, "cluster", &dbforpostgresql.ClusterArgs{
 * 			ClusterName:       pulumi.String("testcluster"),
 * 			Location:          pulumi.String("westus"),
 * 			PointInTimeUTC:    pulumi.String("2017-12-14T00:00:37.467Z"),
 * 			ResourceGroupName: pulumi.String("TestGroup"),
 * 			SourceLocation:    pulumi.String("westus"),
 * 			SourceResourceId:  pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/source-cluster"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Cluster;
 * import com.pulumi.azurenative.dbforpostgresql.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("testcluster")
 *             .location("westus")
 *             .pointInTimeUTC("2017-12-14T00:00:37.467Z")
 *             .resourceGroupName("TestGroup")
 *             .sourceLocation("westus")
 *             .sourceResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/source-cluster")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a new cluster as a read replica
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.DBforPostgreSQL.Cluster("cluster", new()
 *     {
 *         ClusterName = "testcluster",
 *         Location = "westus",
 *         ResourceGroupName = "TestGroup",
 *         SourceLocation = "westus",
 *         SourceResourceId = "/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/sourcecluster",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewCluster(ctx, "cluster", &dbforpostgresql.ClusterArgs{
 * 			ClusterName:       pulumi.String("testcluster"),
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("TestGroup"),
 * 			SourceLocation:    pulumi.String("westus"),
 * 			SourceResourceId:  pulumi.String("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/sourcecluster"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Cluster;
 * import com.pulumi.azurenative.dbforpostgresql.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("testcluster")
 *             .location("westus")
 *             .resourceGroupName("TestGroup")
 *             .sourceLocation("westus")
 *             .sourceResourceId("/subscriptions/ffffffff-ffff-ffff-ffff-ffffffffffff/resourceGroups/TestResourceGroup/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/sourcecluster")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a new multi-node cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.DBforPostgreSQL.Cluster("cluster", new()
 *     {
 *         AdministratorLoginPassword = "password",
 *         CitusVersion = "11.1",
 *         ClusterName = "testcluster-multinode",
 *         CoordinatorEnablePublicIpAccess = true,
 *         CoordinatorServerEdition = "GeneralPurpose",
 *         CoordinatorStorageQuotaInMb = 524288,
 *         CoordinatorVCores = 4,
 *         EnableHa = true,
 *         EnableShardsOnCoordinator = false,
 *         Location = "westus",
 *         NodeCount = 3,
 *         NodeEnablePublicIpAccess = false,
 *         NodeServerEdition = "MemoryOptimized",
 *         NodeStorageQuotaInMb = 524288,
 *         NodeVCores = 8,
 *         PostgresqlVersion = "15",
 *         PreferredPrimaryZone = "1",
 *         ResourceGroupName = "TestGroup",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewCluster(ctx, "cluster", &dbforpostgresql.ClusterArgs{
 * 			AdministratorLoginPassword:      pulumi.String("password"),
 * 			CitusVersion:                    pulumi.String("11.1"),
 * 			ClusterName:                     pulumi.String("testcluster-multinode"),
 * 			CoordinatorEnablePublicIpAccess: pulumi.Bool(true),
 * 			CoordinatorServerEdition:        pulumi.String("GeneralPurpose"),
 * 			CoordinatorStorageQuotaInMb:     pulumi.Int(524288),
 * 			CoordinatorVCores:               pulumi.Int(4),
 * 			EnableHa:                        pulumi.Bool(true),
 * 			EnableShardsOnCoordinator:       pulumi.Bool(false),
 * 			Location:                        pulumi.String("westus"),
 * 			NodeCount:                       pulumi.Int(3),
 * 			NodeEnablePublicIpAccess:        pulumi.Bool(false),
 * 			NodeServerEdition:               pulumi.String("MemoryOptimized"),
 * 			NodeStorageQuotaInMb:            pulumi.Int(524288),
 * 			NodeVCores:                      pulumi.Int(8),
 * 			PostgresqlVersion:               pulumi.String("15"),
 * 			PreferredPrimaryZone:            pulumi.String("1"),
 * 			ResourceGroupName:               pulumi.String("TestGroup"),
 * 			Tags:                            nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Cluster;
 * import com.pulumi.azurenative.dbforpostgresql.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .administratorLoginPassword("password")
 *             .citusVersion("11.1")
 *             .clusterName("testcluster-multinode")
 *             .coordinatorEnablePublicIpAccess(true)
 *             .coordinatorServerEdition("GeneralPurpose")
 *             .coordinatorStorageQuotaInMb(524288)
 *             .coordinatorVCores(4)
 *             .enableHa(true)
 *             .enableShardsOnCoordinator(false)
 *             .location("westus")
 *             .nodeCount(3)
 *             .nodeEnablePublicIpAccess(false)
 *             .nodeServerEdition("MemoryOptimized")
 *             .nodeStorageQuotaInMb(524288)
 *             .nodeVCores(8)
 *             .postgresqlVersion("15")
 *             .preferredPrimaryZone("1")
 *             .resourceGroupName("TestGroup")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create a new single node Burstable 1 vCore cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.DBforPostgreSQL.Cluster("cluster", new()
 *     {
 *         AdministratorLoginPassword = "password",
 *         CitusVersion = "11.3",
 *         ClusterName = "testcluster-burstablev1",
 *         CoordinatorEnablePublicIpAccess = true,
 *         CoordinatorServerEdition = "BurstableMemoryOptimized",
 *         CoordinatorStorageQuotaInMb = 131072,
 *         CoordinatorVCores = 1,
 *         EnableHa = false,
 *         EnableShardsOnCoordinator = true,
 *         Location = "westus",
 *         NodeCount = 0,
 *         PostgresqlVersion = "15",
 *         PreferredPrimaryZone = "1",
 *         ResourceGroupName = "TestGroup",
 *         Tags =
 *         {
 *             { "owner", "JohnDoe" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewCluster(ctx, "cluster", &dbforpostgresql.ClusterArgs{
 * 			AdministratorLoginPassword:      pulumi.String("password"),
 * 			CitusVersion:                    pulumi.String("11.3"),
 * 			ClusterName:                     pulumi.String("testcluster-burstablev1"),
 * 			CoordinatorEnablePublicIpAccess: pulumi.Bool(true),
 * 			CoordinatorServerEdition:        pulumi.String("BurstableMemoryOptimized"),
 * 			CoordinatorStorageQuotaInMb:     pulumi.Int(131072),
 * 			CoordinatorVCores:               pulumi.Int(1),
 * 			EnableHa:                        pulumi.Bool(false),
 * 			EnableShardsOnCoordinator:       pulumi.Bool(true),
 * 			Location:                        pulumi.String("westus"),
 * 			NodeCount:                       pulumi.Int(0),
 * 			PostgresqlVersion:               pulumi.String("15"),
 * 			PreferredPrimaryZone:            pulumi.String("1"),
 * 			ResourceGroupName:               pulumi.String("TestGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"owner": pulumi.String("JohnDoe"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Cluster;
 * import com.pulumi.azurenative.dbforpostgresql.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .administratorLoginPassword("password")
 *             .citusVersion("11.3")
 *             .clusterName("testcluster-burstablev1")
 *             .coordinatorEnablePublicIpAccess(true)
 *             .coordinatorServerEdition("BurstableMemoryOptimized")
 *             .coordinatorStorageQuotaInMb(131072)
 *             .coordinatorVCores(1)
 *             .enableHa(false)
 *             .enableShardsOnCoordinator(true)
 *             .location("westus")
 *             .nodeCount(0)
 *             .postgresqlVersion("15")
 *             .preferredPrimaryZone("1")
 *             .resourceGroupName("TestGroup")
 *             .tags(Map.of("owner", "JohnDoe"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a new single node Burstable 2 vCores cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.DBforPostgreSQL.Cluster("cluster", new()
 *     {
 *         AdministratorLoginPassword = "password",
 *         CitusVersion = "11.3",
 *         ClusterName = "testcluster-burstablev2",
 *         CoordinatorEnablePublicIpAccess = true,
 *         CoordinatorServerEdition = "BurstableGeneralPurpose",
 *         CoordinatorStorageQuotaInMb = 131072,
 *         CoordinatorVCores = 2,
 *         EnableHa = false,
 *         EnableShardsOnCoordinator = true,
 *         Location = "westus",
 *         NodeCount = 0,
 *         PostgresqlVersion = "15",
 *         PreferredPrimaryZone = "1",
 *         ResourceGroupName = "TestGroup",
 *         Tags =
 *         {
 *             { "owner", "JohnDoe" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewCluster(ctx, "cluster", &dbforpostgresql.ClusterArgs{
 * 			AdministratorLoginPassword:      pulumi.String("password"),
 * 			CitusVersion:                    pulumi.String("11.3"),
 * 			ClusterName:                     pulumi.String("testcluster-burstablev2"),
 * 			CoordinatorEnablePublicIpAccess: pulumi.Bool(true),
 * 			CoordinatorServerEdition:        pulumi.String("BurstableGeneralPurpose"),
 * 			CoordinatorStorageQuotaInMb:     pulumi.Int(131072),
 * 			CoordinatorVCores:               pulumi.Int(2),
 * 			EnableHa:                        pulumi.Bool(false),
 * 			EnableShardsOnCoordinator:       pulumi.Bool(true),
 * 			Location:                        pulumi.String("westus"),
 * 			NodeCount:                       pulumi.Int(0),
 * 			PostgresqlVersion:               pulumi.String("15"),
 * 			PreferredPrimaryZone:            pulumi.String("1"),
 * 			ResourceGroupName:               pulumi.String("TestGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"owner": pulumi.String("JohnDoe"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Cluster;
 * import com.pulumi.azurenative.dbforpostgresql.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .administratorLoginPassword("password")
 *             .citusVersion("11.3")
 *             .clusterName("testcluster-burstablev2")
 *             .coordinatorEnablePublicIpAccess(true)
 *             .coordinatorServerEdition("BurstableGeneralPurpose")
 *             .coordinatorStorageQuotaInMb(131072)
 *             .coordinatorVCores(2)
 *             .enableHa(false)
 *             .enableShardsOnCoordinator(true)
 *             .location("westus")
 *             .nodeCount(0)
 *             .postgresqlVersion("15")
 *             .preferredPrimaryZone("1")
 *             .resourceGroupName("TestGroup")
 *             .tags(Map.of("owner", "JohnDoe"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a new single node cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.DBforPostgreSQL.Cluster("cluster", new()
 *     {
 *         AdministratorLoginPassword = "password",
 *         CitusVersion = "11.3",
 *         ClusterName = "testcluster-singlenode",
 *         CoordinatorEnablePublicIpAccess = true,
 *         CoordinatorServerEdition = "GeneralPurpose",
 *         CoordinatorStorageQuotaInMb = 131072,
 *         CoordinatorVCores = 8,
 *         EnableHa = true,
 *         EnableShardsOnCoordinator = true,
 *         Location = "westus",
 *         NodeCount = 0,
 *         PostgresqlVersion = "15",
 *         PreferredPrimaryZone = "1",
 *         ResourceGroupName = "TestGroup",
 *         Tags =
 *         {
 *             { "owner", "JohnDoe" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewCluster(ctx, "cluster", &dbforpostgresql.ClusterArgs{
 * 			AdministratorLoginPassword:      pulumi.String("password"),
 * 			CitusVersion:                    pulumi.String("11.3"),
 * 			ClusterName:                     pulumi.String("testcluster-singlenode"),
 * 			CoordinatorEnablePublicIpAccess: pulumi.Bool(true),
 * 			CoordinatorServerEdition:        pulumi.String("GeneralPurpose"),
 * 			CoordinatorStorageQuotaInMb:     pulumi.Int(131072),
 * 			CoordinatorVCores:               pulumi.Int(8),
 * 			EnableHa:                        pulumi.Bool(true),
 * 			EnableShardsOnCoordinator:       pulumi.Bool(true),
 * 			Location:                        pulumi.String("westus"),
 * 			NodeCount:                       pulumi.Int(0),
 * 			PostgresqlVersion:               pulumi.String("15"),
 * 			PreferredPrimaryZone:            pulumi.String("1"),
 * 			ResourceGroupName:               pulumi.String("TestGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"owner": pulumi.String("JohnDoe"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Cluster;
 * import com.pulumi.azurenative.dbforpostgresql.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .administratorLoginPassword("password")
 *             .citusVersion("11.3")
 *             .clusterName("testcluster-singlenode")
 *             .coordinatorEnablePublicIpAccess(true)
 *             .coordinatorServerEdition("GeneralPurpose")
 *             .coordinatorStorageQuotaInMb(131072)
 *             .coordinatorVCores(8)
 *             .enableHa(true)
 *             .enableShardsOnCoordinator(true)
 *             .location("westus")
 *             .nodeCount(0)
 *             .postgresqlVersion("15")
 *             .preferredPrimaryZone("1")
 *             .resourceGroupName("TestGroup")
 *             .tags(Map.of("owner", "JohnDoe"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbforpostgresql:Cluster testcluster-singlenode /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/{clusterName}
 * ```
 * @property administratorLoginPassword The password of the administrator login. Required for creation.
 * @property citusVersion The Citus extension version on all cluster servers.
 * @property clusterName The name of the cluster.
 * @property coordinatorEnablePublicIpAccess If public access is enabled on coordinator.
 * @property coordinatorServerEdition The edition of a coordinator server (default: GeneralPurpose). Required for creation.
 * @property coordinatorStorageQuotaInMb The storage of a server in MB. Required for creation. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
 * @property coordinatorVCores The vCores count of a server (max: 96). Required for creation. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
 * @property enableHa If high availability (HA) is enabled or not for the cluster.
 * @property enableShardsOnCoordinator If distributed tables are placed on coordinator or not. Should be set to 'true' on single node clusters. Requires shard rebalancing after value is changed.
 * @property location The geo-location where the resource lives
 * @property maintenanceWindow Maintenance window of a cluster.
 * @property nodeCount Worker node count of the cluster. When node count is 0, it represents a single node configuration with the ability to create distributed tables on that node. 2 or more worker nodes represent multi-node configuration. Node count value cannot be 1. Required for creation.
 * @property nodeEnablePublicIpAccess If public access is enabled on worker nodes.
 * @property nodeServerEdition The edition of a node server (default: MemoryOptimized).
 * @property nodeStorageQuotaInMb The storage in MB on each worker node. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
 * @property nodeVCores The compute in vCores on each worker node (max: 104). See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
 * @property pointInTimeUTC Date and time in UTC (ISO8601 format) for cluster restore.
 * @property postgresqlVersion The major PostgreSQL version on all cluster servers.
 * @property preferredPrimaryZone Preferred primary availability zone (AZ) for all cluster servers.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sourceLocation The Azure region of source cluster for read replica clusters.
 * @property sourceResourceId The resource id of source cluster for read replica clusters.
 * @property tags Resource tags.
 */
public data class ClusterArgs(
    public val administratorLoginPassword: Output<String>? = null,
    public val citusVersion: Output<String>? = null,
    public val clusterName: Output<String>? = null,
    public val coordinatorEnablePublicIpAccess: Output<Boolean>? = null,
    public val coordinatorServerEdition: Output<String>? = null,
    public val coordinatorStorageQuotaInMb: Output<Int>? = null,
    public val coordinatorVCores: Output<Int>? = null,
    public val enableHa: Output<Boolean>? = null,
    public val enableShardsOnCoordinator: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val maintenanceWindow: Output<MaintenanceWindowArgs>? = null,
    public val nodeCount: Output<Int>? = null,
    public val nodeEnablePublicIpAccess: Output<Boolean>? = null,
    public val nodeServerEdition: Output<String>? = null,
    public val nodeStorageQuotaInMb: Output<Int>? = null,
    public val nodeVCores: Output<Int>? = null,
    public val pointInTimeUTC: Output<String>? = null,
    public val postgresqlVersion: Output<String>? = null,
    public val preferredPrimaryZone: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sourceLocation: Output<String>? = null,
    public val sourceResourceId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbforpostgresql.ClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.dbforpostgresql.ClusterArgs =
        com.pulumi.azurenative.dbforpostgresql.ClusterArgs.builder()
            .administratorLoginPassword(administratorLoginPassword?.applyValue({ args0 -> args0 }))
            .citusVersion(citusVersion?.applyValue({ args0 -> args0 }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .coordinatorEnablePublicIpAccess(coordinatorEnablePublicIpAccess?.applyValue({ args0 -> args0 }))
            .coordinatorServerEdition(coordinatorServerEdition?.applyValue({ args0 -> args0 }))
            .coordinatorStorageQuotaInMb(coordinatorStorageQuotaInMb?.applyValue({ args0 -> args0 }))
            .coordinatorVCores(coordinatorVCores?.applyValue({ args0 -> args0 }))
            .enableHa(enableHa?.applyValue({ args0 -> args0 }))
            .enableShardsOnCoordinator(enableShardsOnCoordinator?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .maintenanceWindow(maintenanceWindow?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .nodeCount(nodeCount?.applyValue({ args0 -> args0 }))
            .nodeEnablePublicIpAccess(nodeEnablePublicIpAccess?.applyValue({ args0 -> args0 }))
            .nodeServerEdition(nodeServerEdition?.applyValue({ args0 -> args0 }))
            .nodeStorageQuotaInMb(nodeStorageQuotaInMb?.applyValue({ args0 -> args0 }))
            .nodeVCores(nodeVCores?.applyValue({ args0 -> args0 }))
            .pointInTimeUTC(pointInTimeUTC?.applyValue({ args0 -> args0 }))
            .postgresqlVersion(postgresqlVersion?.applyValue({ args0 -> args0 }))
            .preferredPrimaryZone(preferredPrimaryZone?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sourceLocation(sourceLocation?.applyValue({ args0 -> args0 }))
            .sourceResourceId(sourceResourceId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var administratorLoginPassword: Output<String>? = null

    private var citusVersion: Output<String>? = null

    private var clusterName: Output<String>? = null

    private var coordinatorEnablePublicIpAccess: Output<Boolean>? = null

    private var coordinatorServerEdition: Output<String>? = null

    private var coordinatorStorageQuotaInMb: Output<Int>? = null

    private var coordinatorVCores: Output<Int>? = null

    private var enableHa: Output<Boolean>? = null

    private var enableShardsOnCoordinator: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var maintenanceWindow: Output<MaintenanceWindowArgs>? = null

    private var nodeCount: Output<Int>? = null

    private var nodeEnablePublicIpAccess: Output<Boolean>? = null

    private var nodeServerEdition: Output<String>? = null

    private var nodeStorageQuotaInMb: Output<Int>? = null

    private var nodeVCores: Output<Int>? = null

    private var pointInTimeUTC: Output<String>? = null

    private var postgresqlVersion: Output<String>? = null

    private var preferredPrimaryZone: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sourceLocation: Output<String>? = null

    private var sourceResourceId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The password of the administrator login. Required for creation.
     */
    @JvmName("ddymiavreowtcghi")
    public suspend fun administratorLoginPassword(`value`: Output<String>) {
        this.administratorLoginPassword = value
    }

    /**
     * @param value The Citus extension version on all cluster servers.
     */
    @JvmName("mxvdxggwkkermfbk")
    public suspend fun citusVersion(`value`: Output<String>) {
        this.citusVersion = value
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("gwctvomxgwoanscc")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value If public access is enabled on coordinator.
     */
    @JvmName("osqdpxfkvwbscbvs")
    public suspend fun coordinatorEnablePublicIpAccess(`value`: Output<Boolean>) {
        this.coordinatorEnablePublicIpAccess = value
    }

    /**
     * @param value The edition of a coordinator server (default: GeneralPurpose). Required for creation.
     */
    @JvmName("wctdqiqnebifagdp")
    public suspend fun coordinatorServerEdition(`value`: Output<String>) {
        this.coordinatorServerEdition = value
    }

    /**
     * @param value The storage of a server in MB. Required for creation. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
     */
    @JvmName("fcypjxifpasgtlmg")
    public suspend fun coordinatorStorageQuotaInMb(`value`: Output<Int>) {
        this.coordinatorStorageQuotaInMb = value
    }

    /**
     * @param value The vCores count of a server (max: 96). Required for creation. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
     */
    @JvmName("sovwrpcweawinrpm")
    public suspend fun coordinatorVCores(`value`: Output<Int>) {
        this.coordinatorVCores = value
    }

    /**
     * @param value If high availability (HA) is enabled or not for the cluster.
     */
    @JvmName("dmthbgqdhtorvnov")
    public suspend fun enableHa(`value`: Output<Boolean>) {
        this.enableHa = value
    }

    /**
     * @param value If distributed tables are placed on coordinator or not. Should be set to 'true' on single node clusters. Requires shard rebalancing after value is changed.
     */
    @JvmName("pcltfxayurhedewf")
    public suspend fun enableShardsOnCoordinator(`value`: Output<Boolean>) {
        this.enableShardsOnCoordinator = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jorvqclckjpdmemk")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Maintenance window of a cluster.
     */
    @JvmName("xocpxmrshviljynm")
    public suspend fun maintenanceWindow(`value`: Output<MaintenanceWindowArgs>) {
        this.maintenanceWindow = value
    }

    /**
     * @param value Worker node count of the cluster. When node count is 0, it represents a single node configuration with the ability to create distributed tables on that node. 2 or more worker nodes represent multi-node configuration. Node count value cannot be 1. Required for creation.
     */
    @JvmName("jaxsresmoubicykd")
    public suspend fun nodeCount(`value`: Output<Int>) {
        this.nodeCount = value
    }

    /**
     * @param value If public access is enabled on worker nodes.
     */
    @JvmName("uqfroarcqpsdxfxs")
    public suspend fun nodeEnablePublicIpAccess(`value`: Output<Boolean>) {
        this.nodeEnablePublicIpAccess = value
    }

    /**
     * @param value The edition of a node server (default: MemoryOptimized).
     */
    @JvmName("gqtivttfufgyaduu")
    public suspend fun nodeServerEdition(`value`: Output<String>) {
        this.nodeServerEdition = value
    }

    /**
     * @param value The storage in MB on each worker node. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
     */
    @JvmName("wbipnjwisxbejhcd")
    public suspend fun nodeStorageQuotaInMb(`value`: Output<Int>) {
        this.nodeStorageQuotaInMb = value
    }

    /**
     * @param value The compute in vCores on each worker node (max: 104). See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
     */
    @JvmName("qumflfyyrxhtbiav")
    public suspend fun nodeVCores(`value`: Output<Int>) {
        this.nodeVCores = value
    }

    /**
     * @param value Date and time in UTC (ISO8601 format) for cluster restore.
     */
    @JvmName("haljubemseojtbuu")
    public suspend fun pointInTimeUTC(`value`: Output<String>) {
        this.pointInTimeUTC = value
    }

    /**
     * @param value The major PostgreSQL version on all cluster servers.
     */
    @JvmName("xbmbchcxkvflpgpu")
    public suspend fun postgresqlVersion(`value`: Output<String>) {
        this.postgresqlVersion = value
    }

    /**
     * @param value Preferred primary availability zone (AZ) for all cluster servers.
     */
    @JvmName("xehkvobnrbbrjgaw")
    public suspend fun preferredPrimaryZone(`value`: Output<String>) {
        this.preferredPrimaryZone = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tnnxdtqyyygqepby")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Azure region of source cluster for read replica clusters.
     */
    @JvmName("hielmequnfbnftlr")
    public suspend fun sourceLocation(`value`: Output<String>) {
        this.sourceLocation = value
    }

    /**
     * @param value The resource id of source cluster for read replica clusters.
     */
    @JvmName("vhpiijdiwriwhukx")
    public suspend fun sourceResourceId(`value`: Output<String>) {
        this.sourceResourceId = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ygpfoinvqxohsven")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The password of the administrator login. Required for creation.
     */
    @JvmName("dsudfbmnutstdjws")
    public suspend fun administratorLoginPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorLoginPassword = mapped
    }

    /**
     * @param value The Citus extension version on all cluster servers.
     */
    @JvmName("kddkbbvpswynicnn")
    public suspend fun citusVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.citusVersion = mapped
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("emdahlnmvgqykutu")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value If public access is enabled on coordinator.
     */
    @JvmName("trxqlxoexkqflkod")
    public suspend fun coordinatorEnablePublicIpAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coordinatorEnablePublicIpAccess = mapped
    }

    /**
     * @param value The edition of a coordinator server (default: GeneralPurpose). Required for creation.
     */
    @JvmName("kycplmuimjtuvabm")
    public suspend fun coordinatorServerEdition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coordinatorServerEdition = mapped
    }

    /**
     * @param value The storage of a server in MB. Required for creation. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
     */
    @JvmName("mygqquoraxrigicd")
    public suspend fun coordinatorStorageQuotaInMb(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coordinatorStorageQuotaInMb = mapped
    }

    /**
     * @param value The vCores count of a server (max: 96). Required for creation. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
     */
    @JvmName("plwwejfmxrptcykg")
    public suspend fun coordinatorVCores(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coordinatorVCores = mapped
    }

    /**
     * @param value If high availability (HA) is enabled or not for the cluster.
     */
    @JvmName("yxrnalpvvwhdswnj")
    public suspend fun enableHa(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableHa = mapped
    }

    /**
     * @param value If distributed tables are placed on coordinator or not. Should be set to 'true' on single node clusters. Requires shard rebalancing after value is changed.
     */
    @JvmName("sbgxtfmwxqtqrwqk")
    public suspend fun enableShardsOnCoordinator(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableShardsOnCoordinator = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ycvwtdnnjphmqebt")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Maintenance window of a cluster.
     */
    @JvmName("mwukukxiflhfgpvf")
    public suspend fun maintenanceWindow(`value`: MaintenanceWindowArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceWindow = mapped
    }

    /**
     * @param argument Maintenance window of a cluster.
     */
    @JvmName("dgcmgukrnfmbusqe")
    public suspend fun maintenanceWindow(argument: suspend MaintenanceWindowArgsBuilder.() -> Unit) {
        val toBeMapped = MaintenanceWindowArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.maintenanceWindow = mapped
    }

    /**
     * @param value Worker node count of the cluster. When node count is 0, it represents a single node configuration with the ability to create distributed tables on that node. 2 or more worker nodes represent multi-node configuration. Node count value cannot be 1. Required for creation.
     */
    @JvmName("tknvoysaaltawpep")
    public suspend fun nodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeCount = mapped
    }

    /**
     * @param value If public access is enabled on worker nodes.
     */
    @JvmName("cxeckitnamwwswgc")
    public suspend fun nodeEnablePublicIpAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeEnablePublicIpAccess = mapped
    }

    /**
     * @param value The edition of a node server (default: MemoryOptimized).
     */
    @JvmName("aicaytgotstvemab")
    public suspend fun nodeServerEdition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeServerEdition = mapped
    }

    /**
     * @param value The storage in MB on each worker node. See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
     */
    @JvmName("xpvnqrdxrtkyxnjb")
    public suspend fun nodeStorageQuotaInMb(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeStorageQuotaInMb = mapped
    }

    /**
     * @param value The compute in vCores on each worker node (max: 104). See https://learn.microsoft.com/azure/cosmos-db/postgresql/resources-compute for more information.
     */
    @JvmName("bpdsmtffajugvpkq")
    public suspend fun nodeVCores(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeVCores = mapped
    }

    /**
     * @param value Date and time in UTC (ISO8601 format) for cluster restore.
     */
    @JvmName("oeohphltlrifxufm")
    public suspend fun pointInTimeUTC(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pointInTimeUTC = mapped
    }

    /**
     * @param value The major PostgreSQL version on all cluster servers.
     */
    @JvmName("hxlvycctjitiqydb")
    public suspend fun postgresqlVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postgresqlVersion = mapped
    }

    /**
     * @param value Preferred primary availability zone (AZ) for all cluster servers.
     */
    @JvmName("rkgmnemubxjixvus")
    public suspend fun preferredPrimaryZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredPrimaryZone = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rulljbavhwfnggcb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Azure region of source cluster for read replica clusters.
     */
    @JvmName("nvhdjjbxrjtfwwnc")
    public suspend fun sourceLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceLocation = mapped
    }

    /**
     * @param value The resource id of source cluster for read replica clusters.
     */
    @JvmName("qeoyxliiysxkgtro")
    public suspend fun sourceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceId = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vbvmuynxpoapcyxq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("tvwgibjitkxhkofw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        administratorLoginPassword = administratorLoginPassword,
        citusVersion = citusVersion,
        clusterName = clusterName,
        coordinatorEnablePublicIpAccess = coordinatorEnablePublicIpAccess,
        coordinatorServerEdition = coordinatorServerEdition,
        coordinatorStorageQuotaInMb = coordinatorStorageQuotaInMb,
        coordinatorVCores = coordinatorVCores,
        enableHa = enableHa,
        enableShardsOnCoordinator = enableShardsOnCoordinator,
        location = location,
        maintenanceWindow = maintenanceWindow,
        nodeCount = nodeCount,
        nodeEnablePublicIpAccess = nodeEnablePublicIpAccess,
        nodeServerEdition = nodeServerEdition,
        nodeStorageQuotaInMb = nodeStorageQuotaInMb,
        nodeVCores = nodeVCores,
        pointInTimeUTC = pointInTimeUTC,
        postgresqlVersion = postgresqlVersion,
        preferredPrimaryZone = preferredPrimaryZone,
        resourceGroupName = resourceGroupName,
        sourceLocation = sourceLocation,
        sourceResourceId = sourceResourceId,
        tags = tags,
    )
}
