@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin

import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Role].
 */
@PulumiTagMarker
public class RoleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RoleArgs = RoleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RoleArgsBuilder.() -> Unit) {
        val builder = RoleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Role {
        val builtJavaResource = com.pulumi.azurenative.dbforpostgresql.Role(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Role(builtJavaResource)
    }
}

/**
 * Represents a cluster role.
 * Azure REST API version: 2022-11-08.
 * ## Example Usage
 * ### RoleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var role = new AzureNative.DBforPostgreSQL.Role("role", new()
 *     {
 *         ClusterName = "pgtestsvc4",
 *         Password = "password",
 *         ResourceGroupName = "TestGroup",
 *         RoleName = "role1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewRole(ctx, "role", &dbforpostgresql.RoleArgs{
 * 			ClusterName:       pulumi.String("pgtestsvc4"),
 * 			Password:          pulumi.String("password"),
 * 			ResourceGroupName: pulumi.String("TestGroup"),
 * 			RoleName:          pulumi.String("role1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Role;
 * import com.pulumi.azurenative.dbforpostgresql.RoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var role = new Role("role", RoleArgs.builder()
 *             .clusterName("pgtestsvc4")
 *             .password("password")
 *             .resourceGroupName("TestGroup")
 *             .roleName("role1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbforpostgresql:Role role1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/serverGroupsv2/{clusterName}/roles/{roleName}
 * ```
 */
public class Role internal constructor(
    override val javaResource: com.pulumi.azurenative.dbforpostgresql.Role,
) : KotlinCustomResource(javaResource, RoleMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the role
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RoleMapper : ResourceMapper<Role> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.dbforpostgresql.Role::class == javaResource::class

    override fun map(javaResource: Resource): Role = Role(
        javaResource as
            com.pulumi.azurenative.dbforpostgresql.Role,
    )
}

/**
 * @see [Role].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Role].
 */
public suspend fun role(name: String, block: suspend RoleResourceBuilder.() -> Unit): Role {
    val builder = RoleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Role].
 * @param name The _unique_ name of the resulting resource.
 */
public fun role(name: String): Role {
    val builder = RoleResourceBuilder()
    builder.name(name)
    return builder.build()
}
