@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin

import com.pulumi.azurenative.dbforpostgresql.VirtualEndpointArgs.builder
import com.pulumi.azurenative.dbforpostgresql.kotlin.enums.VirtualEndpointType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Represents a virtual endpoint for a server.
 * Azure REST API version: 2023-06-01-preview.
 * ## Example Usage
 * ### Create a new virtual endpoint for a flexible server
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualEndpoint = new AzureNative.DBforPostgreSQL.VirtualEndpoint("virtualEndpoint", new()
 *     {
 *         EndpointType = "ReadWrite",
 *         Members = new[]
 *         {
 *             "testPrimary1",
 *         },
 *         ResourceGroupName = "testrg",
 *         ServerName = "pgtestsvc4",
 *         VirtualEndpointName = "pgVirtualEndpoint1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewVirtualEndpoint(ctx, "virtualEndpoint", &dbforpostgresql.VirtualEndpointArgs{
 * 			EndpointType: pulumi.String("ReadWrite"),
 * 			Members: pulumi.StringArray{
 * 				pulumi.String("testPrimary1"),
 * 			},
 * 			ResourceGroupName:   pulumi.String("testrg"),
 * 			ServerName:          pulumi.String("pgtestsvc4"),
 * 			VirtualEndpointName: pulumi.String("pgVirtualEndpoint1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.VirtualEndpoint;
 * import com.pulumi.azurenative.dbforpostgresql.VirtualEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualEndpoint = new VirtualEndpoint("virtualEndpoint", VirtualEndpointArgs.builder()
 *             .endpointType("ReadWrite")
 *             .members("testPrimary1")
 *             .resourceGroupName("testrg")
 *             .serverName("pgtestsvc4")
 *             .virtualEndpointName("pgVirtualEndpoint1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbforpostgresql:VirtualEndpoint pgVirtualEndpoint1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/virtualendpoints/{virtualEndpointName}
 * ```
 * @property endpointType The endpoint type for the virtual endpoint.
 * @property members List of members for a virtual endpoint
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serverName The name of the server.
 * @property virtualEndpointName The name of the virtual endpoint.
 */
public data class VirtualEndpointArgs(
    public val endpointType: Output<Either<String, VirtualEndpointType>>? = null,
    public val members: Output<List<String>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val virtualEndpointName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbforpostgresql.VirtualEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.dbforpostgresql.VirtualEndpointArgs =
        com.pulumi.azurenative.dbforpostgresql.VirtualEndpointArgs.builder()
            .endpointType(
                endpointType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .members(members?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .virtualEndpointName(virtualEndpointName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualEndpointArgs].
 */
@PulumiTagMarker
public class VirtualEndpointArgsBuilder internal constructor() {
    private var endpointType: Output<Either<String, VirtualEndpointType>>? = null

    private var members: Output<List<String>>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var virtualEndpointName: Output<String>? = null

    /**
     * @param value The endpoint type for the virtual endpoint.
     */
    @JvmName("junovlomvdhacaxt")
    public suspend fun endpointType(`value`: Output<Either<String, VirtualEndpointType>>) {
        this.endpointType = value
    }

    /**
     * @param value List of members for a virtual endpoint
     */
    @JvmName("qmsgdoejnwhnutba")
    public suspend fun members(`value`: Output<List<String>>) {
        this.members = value
    }

    @JvmName("aukbydwjlpdkcswa")
    public suspend fun members(vararg values: Output<String>) {
        this.members = Output.all(values.asList())
    }

    /**
     * @param values List of members for a virtual endpoint
     */
    @JvmName("ktmybludeamnixhc")
    public suspend fun members(values: List<Output<String>>) {
        this.members = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bkesdqvxaodqagvy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("enjwsgghybepinpd")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The name of the virtual endpoint.
     */
    @JvmName("uptuncowrljitxic")
    public suspend fun virtualEndpointName(`value`: Output<String>) {
        this.virtualEndpointName = value
    }

    /**
     * @param value The endpoint type for the virtual endpoint.
     */
    @JvmName("xynvwmtouvxkfmmu")
    public suspend fun endpointType(`value`: Either<String, VirtualEndpointType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value The endpoint type for the virtual endpoint.
     */
    @JvmName("volaafdcnvlyjtfy")
    public fun endpointType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualEndpointType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value The endpoint type for the virtual endpoint.
     */
    @JvmName("kqqsykhadiioejqm")
    public fun endpointType(`value`: VirtualEndpointType) {
        val toBeMapped = Either.ofRight<String, VirtualEndpointType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value List of members for a virtual endpoint
     */
    @JvmName("gyopenjxtxxqbixc")
    public suspend fun members(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.members = mapped
    }

    /**
     * @param values List of members for a virtual endpoint
     */
    @JvmName("tlgkefknyyxjdtea")
    public suspend fun members(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.members = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hjnyanvpobaqoscn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("aiblplauuabrhvmx")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The name of the virtual endpoint.
     */
    @JvmName("xponxvutvinqyelx")
    public suspend fun virtualEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualEndpointName = mapped
    }

    internal fun build(): VirtualEndpointArgs = VirtualEndpointArgs(
        endpointType = endpointType,
        members = members,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        virtualEndpointName = virtualEndpointName,
    )
}
