@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.inputs

import com.pulumi.azurenative.dbforpostgresql.inputs.GetMigrationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property migrationName The name of the migration.
 * @property resourceGroupName The resource group name of the target database server.
 * @property subscriptionId The subscription ID of the target database server.
 * @property targetDbServerName The name of the target database server.
 */
public data class GetMigrationPlainArgs(
    public val migrationName: String,
    public val resourceGroupName: String,
    public val subscriptionId: String? = null,
    public val targetDbServerName: String,
) : ConvertibleToJava<com.pulumi.azurenative.dbforpostgresql.inputs.GetMigrationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.dbforpostgresql.inputs.GetMigrationPlainArgs =
        com.pulumi.azurenative.dbforpostgresql.inputs.GetMigrationPlainArgs.builder()
            .migrationName(migrationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.let({ args0 -> args0 }))
            .targetDbServerName(targetDbServerName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMigrationPlainArgs].
 */
@PulumiTagMarker
public class GetMigrationPlainArgsBuilder internal constructor() {
    private var migrationName: String? = null

    private var resourceGroupName: String? = null

    private var subscriptionId: String? = null

    private var targetDbServerName: String? = null

    /**
     * @param value The name of the migration.
     */
    @JvmName("umyidsxsttdnpigp")
    public suspend fun migrationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.migrationName = mapped
    }

    /**
     * @param value The resource group name of the target database server.
     */
    @JvmName("hdlyerarrhedjfgj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The subscription ID of the target database server.
     */
    @JvmName("pgasokewuofcsgsk")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.subscriptionId = mapped
    }

    /**
     * @param value The name of the target database server.
     */
    @JvmName("esysbbrdbtbeevqj")
    public suspend fun targetDbServerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.targetDbServerName = mapped
    }

    internal fun build(): GetMigrationPlainArgs = GetMigrationPlainArgs(
        migrationName = migrationName ?: throw PulumiNullFieldException("migrationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        subscriptionId = subscriptionId,
        targetDbServerName = targetDbServerName ?: throw PulumiNullFieldException("targetDbServerName"),
    )
}
