@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.inputs

import com.pulumi.azurenative.dbforpostgresql.inputs.GetVirtualEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serverName The name of the server.
 * @property virtualEndpointName The name of the virtual endpoint.
 */
public data class GetVirtualEndpointPlainArgs(
    public val resourceGroupName: String,
    public val serverName: String,
    public val virtualEndpointName: String,
) : ConvertibleToJava<com.pulumi.azurenative.dbforpostgresql.inputs.GetVirtualEndpointPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.dbforpostgresql.inputs.GetVirtualEndpointPlainArgs =
        com.pulumi.azurenative.dbforpostgresql.inputs.GetVirtualEndpointPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 }))
            .virtualEndpointName(virtualEndpointName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualEndpointPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var serverName: String? = null

    private var virtualEndpointName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jimgeurjirvfltee")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("ccfubbdrjjqutwnh")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    /**
     * @param value The name of the virtual endpoint.
     */
    @JvmName("dbtwrumjilriyipr")
    public suspend fun virtualEndpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualEndpointName = mapped
    }

    internal fun build(): GetVirtualEndpointPlainArgs = GetVirtualEndpointPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
        virtualEndpointName = virtualEndpointName ?: throw PulumiNullFieldException("virtualEndpointName"),
    )
}
