@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.inputs

import com.pulumi.azurenative.dbforpostgresql.inputs.MigrationSecretParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Migration secret parameters.
 * @property adminCredentials Admin credentials for source and target servers
 * @property sourceServerUsername Gets or sets the username for the source server. This user need not be an admin.
 * @property targetServerUsername Gets or sets the username for the target server. This user need not be an admin.
 */
public data class MigrationSecretParametersArgs(
    public val adminCredentials: Output<AdminCredentialsArgs>,
    public val sourceServerUsername: Output<String>? = null,
    public val targetServerUsername: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbforpostgresql.inputs.MigrationSecretParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.dbforpostgresql.inputs.MigrationSecretParametersArgs =
        com.pulumi.azurenative.dbforpostgresql.inputs.MigrationSecretParametersArgs.builder()
            .adminCredentials(adminCredentials.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceServerUsername(sourceServerUsername?.applyValue({ args0 -> args0 }))
            .targetServerUsername(targetServerUsername?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MigrationSecretParametersArgs].
 */
@PulumiTagMarker
public class MigrationSecretParametersArgsBuilder internal constructor() {
    private var adminCredentials: Output<AdminCredentialsArgs>? = null

    private var sourceServerUsername: Output<String>? = null

    private var targetServerUsername: Output<String>? = null

    /**
     * @param value Admin credentials for source and target servers
     */
    @JvmName("cdwcfdcjojcnataf")
    public suspend fun adminCredentials(`value`: Output<AdminCredentialsArgs>) {
        this.adminCredentials = value
    }

    /**
     * @param value Gets or sets the username for the source server. This user need not be an admin.
     */
    @JvmName("qaumwgukfdtcawij")
    public suspend fun sourceServerUsername(`value`: Output<String>) {
        this.sourceServerUsername = value
    }

    /**
     * @param value Gets or sets the username for the target server. This user need not be an admin.
     */
    @JvmName("tdkdysgenokdsjec")
    public suspend fun targetServerUsername(`value`: Output<String>) {
        this.targetServerUsername = value
    }

    /**
     * @param value Admin credentials for source and target servers
     */
    @JvmName("wlhjbmihdhcnoyea")
    public suspend fun adminCredentials(`value`: AdminCredentialsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adminCredentials = mapped
    }

    /**
     * @param argument Admin credentials for source and target servers
     */
    @JvmName("ycfdnmhhjgkrxsyv")
    public suspend fun adminCredentials(argument: suspend AdminCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = AdminCredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.adminCredentials = mapped
    }

    /**
     * @param value Gets or sets the username for the source server. This user need not be an admin.
     */
    @JvmName("phslwwadamxqxfxj")
    public suspend fun sourceServerUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceServerUsername = mapped
    }

    /**
     * @param value Gets or sets the username for the target server. This user need not be an admin.
     */
    @JvmName("whlxqkehnnjwobrj")
    public suspend fun targetServerUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetServerUsername = mapped
    }

    internal fun build(): MigrationSecretParametersArgs = MigrationSecretParametersArgs(
        adminCredentials = adminCredentials ?: throw PulumiNullFieldException("adminCredentials"),
        sourceServerUsername = sourceServerUsername,
        targetServerUsername = targetServerUsername,
    )
}
