@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.delegatednetwork.kotlin.inputs

import com.pulumi.azurenative.delegatednetwork.inputs.ControllerDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * controller details
 * @property id controller arm resource id
 */
public data class ControllerDetailsArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.delegatednetwork.inputs.ControllerDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.delegatednetwork.inputs.ControllerDetailsArgs =
        com.pulumi.azurenative.delegatednetwork.inputs.ControllerDetailsArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ControllerDetailsArgs].
 */
@PulumiTagMarker
public class ControllerDetailsArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value controller arm resource id
     */
    @JvmName("ynnwnufkkwetxwvn")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value controller arm resource id
     */
    @JvmName("looryidwycbprpbd")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): ControllerDetailsArgs = ControllerDetailsArgs(
        id = id,
    )
}
