@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.delegatednetwork.kotlin.inputs

import com.pulumi.azurenative.delegatednetwork.inputs.SubnetDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of orchestrator
 * @property id subnet arm resource id
 */
public data class SubnetDetailsArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.delegatednetwork.inputs.SubnetDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.delegatednetwork.inputs.SubnetDetailsArgs =
        com.pulumi.azurenative.delegatednetwork.inputs.SubnetDetailsArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubnetDetailsArgs].
 */
@PulumiTagMarker
public class SubnetDetailsArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value subnet arm resource id
     */
    @JvmName("ogahgbeduwjtvfns")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value subnet arm resource id
     */
    @JvmName("cuojnlhwpvxvbggb")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): SubnetDetailsArgs = SubnetDetailsArgs(
        id = id,
    )
}
