@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin

import com.pulumi.azurenative.desktopvirtualization.DesktopvirtualizationFunctions.getAppAttachPackagePlain
import com.pulumi.azurenative.desktopvirtualization.DesktopvirtualizationFunctions.getApplicationGroupPlain
import com.pulumi.azurenative.desktopvirtualization.DesktopvirtualizationFunctions.getApplicationPlain
import com.pulumi.azurenative.desktopvirtualization.DesktopvirtualizationFunctions.getHostPoolPlain
import com.pulumi.azurenative.desktopvirtualization.DesktopvirtualizationFunctions.getMSIXPackagePlain
import com.pulumi.azurenative.desktopvirtualization.DesktopvirtualizationFunctions.getPrivateEndpointConnectionByHostPoolPlain
import com.pulumi.azurenative.desktopvirtualization.DesktopvirtualizationFunctions.getPrivateEndpointConnectionByWorkspacePlain
import com.pulumi.azurenative.desktopvirtualization.DesktopvirtualizationFunctions.getScalingPlanPersonalSchedulePlain
import com.pulumi.azurenative.desktopvirtualization.DesktopvirtualizationFunctions.getScalingPlanPlain
import com.pulumi.azurenative.desktopvirtualization.DesktopvirtualizationFunctions.getScalingPlanPooledSchedulePlain
import com.pulumi.azurenative.desktopvirtualization.DesktopvirtualizationFunctions.getWorkspacePlain
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.GetAppAttachPackagePlainArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.GetAppAttachPackagePlainArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.GetApplicationGroupPlainArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.GetApplicationGroupPlainArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.GetApplicationPlainArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.GetApplicationPlainArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.GetHostPoolPlainArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.GetHostPoolPlainArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.GetMSIXPackagePlainArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.GetMSIXPackagePlainArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.GetPrivateEndpointConnectionByHostPoolPlainArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.GetPrivateEndpointConnectionByHostPoolPlainArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.GetPrivateEndpointConnectionByWorkspacePlainArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.GetPrivateEndpointConnectionByWorkspacePlainArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.GetScalingPlanPersonalSchedulePlainArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.GetScalingPlanPersonalSchedulePlainArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.GetScalingPlanPlainArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.GetScalingPlanPlainArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.GetScalingPlanPooledSchedulePlainArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.GetScalingPlanPooledSchedulePlainArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.GetWorkspacePlainArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.GetWorkspacePlainArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.GetAppAttachPackageResult
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.GetApplicationGroupResult
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.GetApplicationResult
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.GetHostPoolResult
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.GetMSIXPackageResult
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.GetPrivateEndpointConnectionByHostPoolResult
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.GetPrivateEndpointConnectionByWorkspaceResult
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.GetScalingPlanPersonalScheduleResult
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.GetScalingPlanPooledScheduleResult
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.GetScalingPlanResult
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.GetWorkspaceResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.GetAppAttachPackageResult.Companion.toKotlin as getAppAttachPackageResultToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.GetApplicationGroupResult.Companion.toKotlin as getApplicationGroupResultToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.GetApplicationResult.Companion.toKotlin as getApplicationResultToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.GetHostPoolResult.Companion.toKotlin as getHostPoolResultToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.GetMSIXPackageResult.Companion.toKotlin as getMSIXPackageResultToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.GetPrivateEndpointConnectionByHostPoolResult.Companion.toKotlin as getPrivateEndpointConnectionByHostPoolResultToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.GetPrivateEndpointConnectionByWorkspaceResult.Companion.toKotlin as getPrivateEndpointConnectionByWorkspaceResultToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.GetScalingPlanPersonalScheduleResult.Companion.toKotlin as getScalingPlanPersonalScheduleResultToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.GetScalingPlanPooledScheduleResult.Companion.toKotlin as getScalingPlanPooledScheduleResultToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.GetScalingPlanResult.Companion.toKotlin as getScalingPlanResultToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.GetWorkspaceResult.Companion.toKotlin as getWorkspaceResultToKotlin

public object DesktopvirtualizationFunctions {
    /**
     * Get an app attach package.
     * Azure REST API version: 2023-10-04-preview.
     * Other available API versions: 2023-11-01-preview, 2024-01-16-preview.
     * @param argument null
     * @return Schema for App Attach Package properties.
     */
    public suspend fun getAppAttachPackage(argument: GetAppAttachPackagePlainArgs):
        GetAppAttachPackageResult =
        getAppAttachPackageResultToKotlin(getAppAttachPackagePlain(argument.toJava()).await())

    /**
     * @see [getAppAttachPackage].
     * @param appAttachPackageName The name of the App Attach package arm object
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Schema for App Attach Package properties.
     */
    public suspend fun getAppAttachPackage(appAttachPackageName: String, resourceGroupName: String):
        GetAppAttachPackageResult {
        val argument = GetAppAttachPackagePlainArgs(
            appAttachPackageName = appAttachPackageName,
            resourceGroupName = resourceGroupName,
        )
        return getAppAttachPackageResultToKotlin(getAppAttachPackagePlain(argument.toJava()).await())
    }

    /**
     * @see [getAppAttachPackage].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;desktopvirtualization&#46;kotlin&#46;inputs&#46;GetAppAttachPackagePlainArgs].
     * @return Schema for App Attach Package properties.
     */
    public suspend
    fun getAppAttachPackage(argument: suspend GetAppAttachPackagePlainArgsBuilder.() -> Unit):
        GetAppAttachPackageResult {
        val builder = GetAppAttachPackagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAppAttachPackageResultToKotlin(getAppAttachPackagePlain(builtArgument.toJava()).await())
    }

    /**
     * Get an application.
     * Azure REST API version: 2022-09-09.
     * Other available API versions: 2022-10-14-preview, 2023-07-07-preview, 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview.
     * @param argument null
     * @return Schema for Application properties.
     */
    public suspend fun getApplication(argument: GetApplicationPlainArgs): GetApplicationResult =
        getApplicationResultToKotlin(getApplicationPlain(argument.toJava()).await())

    /**
     * @see [getApplication].
     * @param applicationGroupName The name of the application group
     * @param applicationName The name of the application within the specified application group
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Schema for Application properties.
     */
    public suspend fun getApplication(
        applicationGroupName: String,
        applicationName: String,
        resourceGroupName: String,
    ): GetApplicationResult {
        val argument = GetApplicationPlainArgs(
            applicationGroupName = applicationGroupName,
            applicationName = applicationName,
            resourceGroupName = resourceGroupName,
        )
        return getApplicationResultToKotlin(getApplicationPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplication].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;desktopvirtualization&#46;kotlin&#46;inputs&#46;GetApplicationPlainArgs].
     * @return Schema for Application properties.
     */
    public suspend fun getApplication(argument: suspend GetApplicationPlainArgsBuilder.() -> Unit):
        GetApplicationResult {
        val builder = GetApplicationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationResultToKotlin(getApplicationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get an application group.
     * Azure REST API version: 2022-09-09.
     * Other available API versions: 2020-11-10-preview, 2022-04-01-preview, 2022-10-14-preview, 2023-07-07-preview, 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview.
     * @param argument null
     * @return Represents a ApplicationGroup definition.
     */
    public suspend fun getApplicationGroup(argument: GetApplicationGroupPlainArgs):
        GetApplicationGroupResult =
        getApplicationGroupResultToKotlin(getApplicationGroupPlain(argument.toJava()).await())

    /**
     * @see [getApplicationGroup].
     * @param applicationGroupName The name of the application group
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Represents a ApplicationGroup definition.
     */
    public suspend fun getApplicationGroup(applicationGroupName: String, resourceGroupName: String):
        GetApplicationGroupResult {
        val argument = GetApplicationGroupPlainArgs(
            applicationGroupName = applicationGroupName,
            resourceGroupName = resourceGroupName,
        )
        return getApplicationGroupResultToKotlin(getApplicationGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplicationGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;desktopvirtualization&#46;kotlin&#46;inputs&#46;GetApplicationGroupPlainArgs].
     * @return Represents a ApplicationGroup definition.
     */
    public suspend
    fun getApplicationGroup(argument: suspend GetApplicationGroupPlainArgsBuilder.() -> Unit):
        GetApplicationGroupResult {
        val builder = GetApplicationGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationGroupResultToKotlin(getApplicationGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a host pool.
     * Azure REST API version: 2022-09-09.
     * Other available API versions: 2020-11-02-preview, 2020-11-10-preview, 2022-04-01-preview, 2022-10-14-preview, 2023-07-07-preview, 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview.
     * @param argument null
     * @return Represents a HostPool definition.
     */
    public suspend fun getHostPool(argument: GetHostPoolPlainArgs): GetHostPoolResult =
        getHostPoolResultToKotlin(getHostPoolPlain(argument.toJava()).await())

    /**
     * @see [getHostPool].
     * @param hostPoolName The name of the host pool within the specified resource group
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Represents a HostPool definition.
     */
    public suspend fun getHostPool(hostPoolName: String, resourceGroupName: String):
        GetHostPoolResult {
        val argument = GetHostPoolPlainArgs(
            hostPoolName = hostPoolName,
            resourceGroupName = resourceGroupName,
        )
        return getHostPoolResultToKotlin(getHostPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getHostPool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;desktopvirtualization&#46;kotlin&#46;inputs&#46;GetHostPoolPlainArgs].
     * @return Represents a HostPool definition.
     */
    public suspend fun getHostPool(argument: suspend GetHostPoolPlainArgsBuilder.() -> Unit):
        GetHostPoolResult {
        val builder = GetHostPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHostPoolResultToKotlin(getHostPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a msixpackage.
     * Azure REST API version: 2022-09-09.
     * Other available API versions: 2022-10-14-preview, 2023-07-07-preview, 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview.
     * @param argument null
     * @return Schema for MSIX Package properties.
     */
    public suspend fun getMSIXPackage(argument: GetMSIXPackagePlainArgs): GetMSIXPackageResult =
        getMSIXPackageResultToKotlin(getMSIXPackagePlain(argument.toJava()).await())

    /**
     * @see [getMSIXPackage].
     * @param hostPoolName The name of the host pool within the specified resource group
     * @param msixPackageFullName The version specific package full name of the MSIX package within specified hostpool
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Schema for MSIX Package properties.
     */
    public suspend fun getMSIXPackage(
        hostPoolName: String,
        msixPackageFullName: String,
        resourceGroupName: String,
    ): GetMSIXPackageResult {
        val argument = GetMSIXPackagePlainArgs(
            hostPoolName = hostPoolName,
            msixPackageFullName = msixPackageFullName,
            resourceGroupName = resourceGroupName,
        )
        return getMSIXPackageResultToKotlin(getMSIXPackagePlain(argument.toJava()).await())
    }

    /**
     * @see [getMSIXPackage].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;desktopvirtualization&#46;kotlin&#46;inputs&#46;GetMSIXPackagePlainArgs].
     * @return Schema for MSIX Package properties.
     */
    public suspend fun getMSIXPackage(argument: suspend GetMSIXPackagePlainArgsBuilder.() -> Unit):
        GetMSIXPackageResult {
        val builder = GetMSIXPackagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMSIXPackageResultToKotlin(getMSIXPackagePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a private endpoint connection.
     * Azure REST API version: 2022-10-14-preview.
     * Other available API versions: 2023-07-07-preview, 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnectionByHostPool(argument: GetPrivateEndpointConnectionByHostPoolPlainArgs):
        GetPrivateEndpointConnectionByHostPoolResult =
        getPrivateEndpointConnectionByHostPoolResultToKotlin(getPrivateEndpointConnectionByHostPoolPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnectionByHostPool].
     * @param hostPoolName The name of the host pool within the specified resource group
     * @param privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnectionByHostPool(
        hostPoolName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionByHostPoolResult {
        val argument = GetPrivateEndpointConnectionByHostPoolPlainArgs(
            hostPoolName = hostPoolName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionByHostPoolResultToKotlin(getPrivateEndpointConnectionByHostPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnectionByHostPool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;desktopvirtualization&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionByHostPoolPlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnectionByHostPool(argument: suspend GetPrivateEndpointConnectionByHostPoolPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionByHostPoolResult {
        val builder = GetPrivateEndpointConnectionByHostPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionByHostPoolResultToKotlin(getPrivateEndpointConnectionByHostPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a private endpoint connection.
     * Azure REST API version: 2022-10-14-preview.
     * Other available API versions: 2023-07-07-preview, 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnectionByWorkspace(argument: GetPrivateEndpointConnectionByWorkspacePlainArgs):
        GetPrivateEndpointConnectionByWorkspaceResult =
        getPrivateEndpointConnectionByWorkspaceResultToKotlin(getPrivateEndpointConnectionByWorkspacePlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnectionByWorkspace].
     * @param privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnectionByWorkspace(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetPrivateEndpointConnectionByWorkspaceResult {
        val argument = GetPrivateEndpointConnectionByWorkspacePlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getPrivateEndpointConnectionByWorkspaceResultToKotlin(getPrivateEndpointConnectionByWorkspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnectionByWorkspace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;desktopvirtualization&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionByWorkspacePlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnectionByWorkspace(argument: suspend GetPrivateEndpointConnectionByWorkspacePlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionByWorkspaceResult {
        val builder = GetPrivateEndpointConnectionByWorkspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionByWorkspaceResultToKotlin(getPrivateEndpointConnectionByWorkspacePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a scaling plan.
     * Azure REST API version: 2022-09-09.
     * Other available API versions: 2020-11-10-preview, 2021-02-01-preview, 2022-02-10-preview, 2022-10-14-preview, 2023-07-07-preview, 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview.
     * @param argument null
     * @return Represents a scaling plan definition.
     */
    public suspend fun getScalingPlan(argument: GetScalingPlanPlainArgs): GetScalingPlanResult =
        getScalingPlanResultToKotlin(getScalingPlanPlain(argument.toJava()).await())

    /**
     * @see [getScalingPlan].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param scalingPlanName The name of the scaling plan.
     * @return Represents a scaling plan definition.
     */
    public suspend fun getScalingPlan(resourceGroupName: String, scalingPlanName: String):
        GetScalingPlanResult {
        val argument = GetScalingPlanPlainArgs(
            resourceGroupName = resourceGroupName,
            scalingPlanName = scalingPlanName,
        )
        return getScalingPlanResultToKotlin(getScalingPlanPlain(argument.toJava()).await())
    }

    /**
     * @see [getScalingPlan].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;desktopvirtualization&#46;kotlin&#46;inputs&#46;GetScalingPlanPlainArgs].
     * @return Represents a scaling plan definition.
     */
    public suspend fun getScalingPlan(argument: suspend GetScalingPlanPlainArgsBuilder.() -> Unit):
        GetScalingPlanResult {
        val builder = GetScalingPlanPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScalingPlanResultToKotlin(getScalingPlanPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a ScalingPlanPersonalSchedule.
     * Azure REST API version: 2023-07-07-preview.
     * Other available API versions: 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview.
     * @param argument null
     * @return Represents a ScalingPlanPersonalSchedule definition.
     */
    public suspend
    fun getScalingPlanPersonalSchedule(argument: GetScalingPlanPersonalSchedulePlainArgs):
        GetScalingPlanPersonalScheduleResult =
        getScalingPlanPersonalScheduleResultToKotlin(getScalingPlanPersonalSchedulePlain(argument.toJava()).await())

    /**
     * @see [getScalingPlanPersonalSchedule].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param scalingPlanName The name of the scaling plan.
     * @param scalingPlanScheduleName The name of the ScalingPlanSchedule
     * @return Represents a ScalingPlanPersonalSchedule definition.
     */
    public suspend fun getScalingPlanPersonalSchedule(
        resourceGroupName: String,
        scalingPlanName: String,
        scalingPlanScheduleName: String,
    ): GetScalingPlanPersonalScheduleResult {
        val argument = GetScalingPlanPersonalSchedulePlainArgs(
            resourceGroupName = resourceGroupName,
            scalingPlanName = scalingPlanName,
            scalingPlanScheduleName = scalingPlanScheduleName,
        )
        return getScalingPlanPersonalScheduleResultToKotlin(getScalingPlanPersonalSchedulePlain(argument.toJava()).await())
    }

    /**
     * @see [getScalingPlanPersonalSchedule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;desktopvirtualization&#46;kotlin&#46;inputs&#46;GetScalingPlanPersonalSchedulePlainArgs].
     * @return Represents a ScalingPlanPersonalSchedule definition.
     */
    public suspend
    fun getScalingPlanPersonalSchedule(argument: suspend GetScalingPlanPersonalSchedulePlainArgsBuilder.() -> Unit):
        GetScalingPlanPersonalScheduleResult {
        val builder = GetScalingPlanPersonalSchedulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScalingPlanPersonalScheduleResultToKotlin(getScalingPlanPersonalSchedulePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a ScalingPlanPooledSchedule.
     * Azure REST API version: 2022-09-09.
     * Other available API versions: 2022-10-14-preview, 2023-07-07-preview, 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview.
     * @param argument null
     * @return Represents a ScalingPlanPooledSchedule definition.
     */
    public suspend fun getScalingPlanPooledSchedule(argument: GetScalingPlanPooledSchedulePlainArgs):
        GetScalingPlanPooledScheduleResult =
        getScalingPlanPooledScheduleResultToKotlin(getScalingPlanPooledSchedulePlain(argument.toJava()).await())

    /**
     * @see [getScalingPlanPooledSchedule].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param scalingPlanName The name of the scaling plan.
     * @param scalingPlanScheduleName The name of the ScalingPlanSchedule
     * @return Represents a ScalingPlanPooledSchedule definition.
     */
    public suspend fun getScalingPlanPooledSchedule(
        resourceGroupName: String,
        scalingPlanName: String,
        scalingPlanScheduleName: String,
    ): GetScalingPlanPooledScheduleResult {
        val argument = GetScalingPlanPooledSchedulePlainArgs(
            resourceGroupName = resourceGroupName,
            scalingPlanName = scalingPlanName,
            scalingPlanScheduleName = scalingPlanScheduleName,
        )
        return getScalingPlanPooledScheduleResultToKotlin(getScalingPlanPooledSchedulePlain(argument.toJava()).await())
    }

    /**
     * @see [getScalingPlanPooledSchedule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;desktopvirtualization&#46;kotlin&#46;inputs&#46;GetScalingPlanPooledSchedulePlainArgs].
     * @return Represents a ScalingPlanPooledSchedule definition.
     */
    public suspend
    fun getScalingPlanPooledSchedule(argument: suspend GetScalingPlanPooledSchedulePlainArgsBuilder.() -> Unit):
        GetScalingPlanPooledScheduleResult {
        val builder = GetScalingPlanPooledSchedulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScalingPlanPooledScheduleResultToKotlin(getScalingPlanPooledSchedulePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a workspace.
     * Azure REST API version: 2022-09-09.
     * Other available API versions: 2020-11-10-preview, 2022-10-14-preview, 2023-07-07-preview, 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview.
     * @param argument null
     * @return Represents a Workspace definition.
     */
    public suspend fun getWorkspace(argument: GetWorkspacePlainArgs): GetWorkspaceResult =
        getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())

    /**
     * @see [getWorkspace].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the workspace
     * @return Represents a Workspace definition.
     */
    public suspend fun getWorkspace(resourceGroupName: String, workspaceName: String):
        GetWorkspaceResult {
        val argument = GetWorkspacePlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;desktopvirtualization&#46;kotlin&#46;inputs&#46;GetWorkspacePlainArgs].
     * @return Represents a Workspace definition.
     */
    public suspend fun getWorkspace(argument: suspend GetWorkspacePlainArgsBuilder.() -> Unit):
        GetWorkspaceResult {
        val builder = GetWorkspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceResultToKotlin(getWorkspacePlain(builtArgument.toJava()).await())
    }
}
