@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin

import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.PrivateEndpointResponse
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.PrivateLinkServiceConnectionStateResponse
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin as privateEndpointResponseToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin as privateLinkServiceConnectionStateResponseToKotlin
import com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PrivateEndpointConnectionByWorkspace].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionByWorkspaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateEndpointConnectionByWorkspaceArgs =
        PrivateEndpointConnectionByWorkspaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend PrivateEndpointConnectionByWorkspaceArgsBuilder.() -> Unit) {
        val builder = PrivateEndpointConnectionByWorkspaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PrivateEndpointConnectionByWorkspace {
        val builtJavaResource =
            com.pulumi.azurenative.desktopvirtualization.PrivateEndpointConnectionByWorkspace(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrivateEndpointConnectionByWorkspace(builtJavaResource)
    }
}

/**
 * The Private Endpoint Connection resource.
 * Azure REST API version: 2022-10-14-preview. Prior API version in Azure Native 1.x: 2021-04-01-preview.
 * Other available API versions: 2023-07-07-preview, 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview.
 * ## Example Usage
 * ### PrivateEndpointConnection_UpdateByWorkspace
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnectionByWorkspace = new AzureNative.DesktopVirtualization.PrivateEndpointConnectionByWorkspace("privateEndpointConnectionByWorkspace", new()
 *     {
 *         PrivateEndpointConnectionName = "workspace1.377103f1-5179-4bdf-8556-4cdd3207cc5b",
 *         PrivateLinkServiceConnectionState = new AzureNative.DesktopVirtualization.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             ActionsRequired = "None",
 *             Description = "Approved by admin@consoto.com",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "resourceGroup1",
 *         WorkspaceName = "workspace1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/desktopvirtualization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := desktopvirtualization.NewPrivateEndpointConnectionByWorkspace(ctx, "privateEndpointConnectionByWorkspace", &desktopvirtualization.PrivateEndpointConnectionByWorkspaceArgs{
 * 			PrivateEndpointConnectionName: pulumi.String("workspace1.377103f1-5179-4bdf-8556-4cdd3207cc5b"),
 * 			PrivateLinkServiceConnectionState: &desktopvirtualization.PrivateLinkServiceConnectionStateArgs{
 * 				ActionsRequired: pulumi.String("None"),
 * 				Description:     pulumi.String("Approved by admin@consoto.com"),
 * 				Status:          pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroup1"),
 * 			WorkspaceName:     pulumi.String("workspace1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.desktopvirtualization.PrivateEndpointConnectionByWorkspace;
 * import com.pulumi.azurenative.desktopvirtualization.PrivateEndpointConnectionByWorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnectionByWorkspace = new PrivateEndpointConnectionByWorkspace("privateEndpointConnectionByWorkspace", PrivateEndpointConnectionByWorkspaceArgs.builder()
 *             .privateEndpointConnectionName("workspace1.377103f1-5179-4bdf-8556-4cdd3207cc5b")
 *             .privateLinkServiceConnectionState(Map.ofEntries(
 *                 Map.entry("actionsRequired", "None"),
 *                 Map.entry("description", "Approved by admin@consoto.com"),
 *                 Map.entry("status", "Approved")
 *             ))
 *             .resourceGroupName("resourceGroup1")
 *             .workspaceName("workspace1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:desktopvirtualization:PrivateEndpointConnectionByWorkspace workspace1.377103f1-5179-4bdf-8556-4cdd3207cc5b /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/workspaces/{workspaceName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 */
public class PrivateEndpointConnectionByWorkspace internal constructor(
    override val javaResource:
    com.pulumi.azurenative.desktopvirtualization.PrivateEndpointConnectionByWorkspace,
) : KotlinCustomResource(javaResource, PrivateEndpointConnectionByWorkspaceMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The resource of private end point.
     */
    public val privateEndpoint: Output<PrivateEndpointResponse>?
        get() = javaResource.privateEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateEndpointResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A collection of information about the state of the connection between service consumer and provider.
     */
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateResponse>
        get() = javaResource.privateLinkServiceConnectionState().applyValue({ args0 ->
            args0.let({ args0 -> privateLinkServiceConnectionStateResponseToKotlin(args0) })
        })

    /**
     * The provisioning state of the private endpoint connection resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateEndpointConnectionByWorkspaceMapper :
    ResourceMapper<PrivateEndpointConnectionByWorkspace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.desktopvirtualization.PrivateEndpointConnectionByWorkspace::class == javaResource::class

    override fun map(javaResource: Resource): PrivateEndpointConnectionByWorkspace =
        PrivateEndpointConnectionByWorkspace(
            javaResource as
                com.pulumi.azurenative.desktopvirtualization.PrivateEndpointConnectionByWorkspace,
        )
}

/**
 * @see [PrivateEndpointConnectionByWorkspace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateEndpointConnectionByWorkspace].
 */
public suspend fun privateEndpointConnectionByWorkspace(
    name: String,
    block: suspend PrivateEndpointConnectionByWorkspaceResourceBuilder.() -> Unit,
):
    PrivateEndpointConnectionByWorkspace {
    val builder = PrivateEndpointConnectionByWorkspaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateEndpointConnectionByWorkspace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateEndpointConnectionByWorkspace(name: String):
    PrivateEndpointConnectionByWorkspace {
    val builder = PrivateEndpointConnectionByWorkspaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
