@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin

import com.pulumi.azurenative.desktopvirtualization.ScalingPlanPooledScheduleArgs.builder
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.DayOfWeek
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.SessionHostLoadBalancingAlgorithm
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.StopHostsWhen
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.TimeArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.TimeArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Represents a ScalingPlanPooledSchedule definition.
 * Azure REST API version: 2022-09-09. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2022-10-14-preview, 2023-07-07-preview, 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview.
 * ## Example Usage
 * ### ScalingPlanPooledSchedules_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scalingPlanPooledSchedule = new AzureNative.DesktopVirtualization.ScalingPlanPooledSchedule("scalingPlanPooledSchedule", new()
 *     {
 *         DaysOfWeek = new[]
 *         {
 *             "Monday",
 *             "Tuesday",
 *             "Wednesday",
 *             "Thursday",
 *             "Friday",
 *         },
 *         OffPeakLoadBalancingAlgorithm = "DepthFirst",
 *         OffPeakStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *         {
 *             Hour = 20,
 *             Minute = 0,
 *         },
 *         PeakLoadBalancingAlgorithm = "BreadthFirst",
 *         PeakStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *         {
 *             Hour = 8,
 *             Minute = 0,
 *         },
 *         RampDownCapacityThresholdPct = 50,
 *         RampDownForceLogoffUsers = true,
 *         RampDownLoadBalancingAlgorithm = "DepthFirst",
 *         RampDownMinimumHostsPct = 20,
 *         RampDownNotificationMessage = "message",
 *         RampDownStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *         {
 *             Hour = 18,
 *             Minute = 0,
 *         },
 *         RampDownWaitTimeMinutes = 30,
 *         RampUpCapacityThresholdPct = 80,
 *         RampUpLoadBalancingAlgorithm = "DepthFirst",
 *         RampUpMinimumHostsPct = 20,
 *         RampUpStartTime = new AzureNative.DesktopVirtualization.Inputs.TimeArgs
 *         {
 *             Hour = 6,
 *             Minute = 0,
 *         },
 *         ResourceGroupName = "resourceGroup1",
 *         ScalingPlanName = "scalingPlan1",
 *         ScalingPlanScheduleName = "scalingPlanScheduleWeekdays1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/desktopvirtualization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := desktopvirtualization.NewScalingPlanPooledSchedule(ctx, "scalingPlanPooledSchedule", &desktopvirtualization.ScalingPlanPooledScheduleArgs{
 * 			DaysOfWeek: pulumi.StringArray{
 * 				pulumi.String("Monday"),
 * 				pulumi.String("Tuesday"),
 * 				pulumi.String("Wednesday"),
 * 				pulumi.String("Thursday"),
 * 				pulumi.String("Friday"),
 * 			},
 * 			OffPeakLoadBalancingAlgorithm: pulumi.String("DepthFirst"),
 * 			OffPeakStartTime: &desktopvirtualization.TimeArgs{
 * 				Hour:   pulumi.Int(20),
 * 				Minute: pulumi.Int(0),
 * 			},
 * 			PeakLoadBalancingAlgorithm: pulumi.String("BreadthFirst"),
 * 			PeakStartTime: &desktopvirtualization.TimeArgs{
 * 				Hour:   pulumi.Int(8),
 * 				Minute: pulumi.Int(0),
 * 			},
 * 			RampDownCapacityThresholdPct:   pulumi.Int(50),
 * 			RampDownForceLogoffUsers:       pulumi.Bool(true),
 * 			RampDownLoadBalancingAlgorithm: pulumi.String("DepthFirst"),
 * 			RampDownMinimumHostsPct:        pulumi.Int(20),
 * 			RampDownNotificationMessage:    pulumi.String("message"),
 * 			RampDownStartTime: &desktopvirtualization.TimeArgs{
 * 				Hour:   pulumi.Int(18),
 * 				Minute: pulumi.Int(0),
 * 			},
 * 			RampDownWaitTimeMinutes:      pulumi.Int(30),
 * 			RampUpCapacityThresholdPct:   pulumi.Int(80),
 * 			RampUpLoadBalancingAlgorithm: pulumi.String("DepthFirst"),
 * 			RampUpMinimumHostsPct:        pulumi.Int(20),
 * 			RampUpStartTime: &desktopvirtualization.TimeArgs{
 * 				Hour:   pulumi.Int(6),
 * 				Minute: pulumi.Int(0),
 * 			},
 * 			ResourceGroupName:       pulumi.String("resourceGroup1"),
 * 			ScalingPlanName:         pulumi.String("scalingPlan1"),
 * 			ScalingPlanScheduleName: pulumi.String("scalingPlanScheduleWeekdays1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.desktopvirtualization.ScalingPlanPooledSchedule;
 * import com.pulumi.azurenative.desktopvirtualization.ScalingPlanPooledScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scalingPlanPooledSchedule = new ScalingPlanPooledSchedule("scalingPlanPooledSchedule", ScalingPlanPooledScheduleArgs.builder()
 *             .daysOfWeek(
 *                 "Monday",
 *                 "Tuesday",
 *                 "Wednesday",
 *                 "Thursday",
 *                 "Friday")
 *             .offPeakLoadBalancingAlgorithm("DepthFirst")
 *             .offPeakStartTime(Map.ofEntries(
 *                 Map.entry("hour", 20),
 *                 Map.entry("minute", 0)
 *             ))
 *             .peakLoadBalancingAlgorithm("BreadthFirst")
 *             .peakStartTime(Map.ofEntries(
 *                 Map.entry("hour", 8),
 *                 Map.entry("minute", 0)
 *             ))
 *             .rampDownCapacityThresholdPct(50)
 *             .rampDownForceLogoffUsers(true)
 *             .rampDownLoadBalancingAlgorithm("DepthFirst")
 *             .rampDownMinimumHostsPct(20)
 *             .rampDownNotificationMessage("message")
 *             .rampDownStartTime(Map.ofEntries(
 *                 Map.entry("hour", 18),
 *                 Map.entry("minute", 0)
 *             ))
 *             .rampDownWaitTimeMinutes(30)
 *             .rampUpCapacityThresholdPct(80)
 *             .rampUpLoadBalancingAlgorithm("DepthFirst")
 *             .rampUpMinimumHostsPct(20)
 *             .rampUpStartTime(Map.ofEntries(
 *                 Map.entry("hour", 6),
 *                 Map.entry("minute", 0)
 *             ))
 *             .resourceGroupName("resourceGroup1")
 *             .scalingPlanName("scalingPlan1")
 *             .scalingPlanScheduleName("scalingPlanScheduleWeekdays1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:desktopvirtualization:ScalingPlanPooledSchedule scalingPlanScheduleWeekdays1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/scalingPlans/{scalingPlanName}/pooledSchedules/{scalingPlanScheduleName}
 * ```
 * @property daysOfWeek Set of days of the week on which this schedule is active.
 * @property offPeakLoadBalancingAlgorithm Load balancing algorithm for off-peak period.
 * @property offPeakStartTime Starting time for off-peak period.
 * @property peakLoadBalancingAlgorithm Load balancing algorithm for peak period.
 * @property peakStartTime Starting time for peak period.
 * @property rampDownCapacityThresholdPct Capacity threshold for ramp down period.
 * @property rampDownForceLogoffUsers Should users be logged off forcefully from hosts.
 * @property rampDownLoadBalancingAlgorithm Load balancing algorithm for ramp down period.
 * @property rampDownMinimumHostsPct Minimum host percentage for ramp down period.
 * @property rampDownNotificationMessage Notification message for users during ramp down period.
 * @property rampDownStartTime Starting time for ramp down period.
 * @property rampDownStopHostsWhen Specifies when to stop hosts during ramp down period.
 * @property rampDownWaitTimeMinutes Number of minutes to wait to stop hosts during ramp down period.
 * @property rampUpCapacityThresholdPct Capacity threshold for ramp up period.
 * @property rampUpLoadBalancingAlgorithm Load balancing algorithm for ramp up period.
 * @property rampUpMinimumHostsPct Minimum host percentage for ramp up period.
 * @property rampUpStartTime Starting time for ramp up period.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property scalingPlanName The name of the scaling plan.
 * @property scalingPlanScheduleName The name of the ScalingPlanSchedule
 */
public data class ScalingPlanPooledScheduleArgs(
    public val daysOfWeek: Output<List<Either<String, DayOfWeek>>>? = null,
    public val offPeakLoadBalancingAlgorithm:
    Output<Either<String, SessionHostLoadBalancingAlgorithm>>? = null,
    public val offPeakStartTime: Output<TimeArgs>? = null,
    public val peakLoadBalancingAlgorithm: Output<Either<String, SessionHostLoadBalancingAlgorithm>>? =
        null,
    public val peakStartTime: Output<TimeArgs>? = null,
    public val rampDownCapacityThresholdPct: Output<Int>? = null,
    public val rampDownForceLogoffUsers: Output<Boolean>? = null,
    public val rampDownLoadBalancingAlgorithm:
    Output<Either<String, SessionHostLoadBalancingAlgorithm>>? = null,
    public val rampDownMinimumHostsPct: Output<Int>? = null,
    public val rampDownNotificationMessage: Output<String>? = null,
    public val rampDownStartTime: Output<TimeArgs>? = null,
    public val rampDownStopHostsWhen: Output<Either<String, StopHostsWhen>>? = null,
    public val rampDownWaitTimeMinutes: Output<Int>? = null,
    public val rampUpCapacityThresholdPct: Output<Int>? = null,
    public val rampUpLoadBalancingAlgorithm:
    Output<Either<String, SessionHostLoadBalancingAlgorithm>>? = null,
    public val rampUpMinimumHostsPct: Output<Int>? = null,
    public val rampUpStartTime: Output<TimeArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scalingPlanName: Output<String>? = null,
    public val scalingPlanScheduleName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.ScalingPlanPooledScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.desktopvirtualization.ScalingPlanPooledScheduleArgs =
        com.pulumi.azurenative.desktopvirtualization.ScalingPlanPooledScheduleArgs.builder()
            .daysOfWeek(
                daysOfWeek?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .offPeakLoadBalancingAlgorithm(
                offPeakLoadBalancingAlgorithm?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .offPeakStartTime(offPeakStartTime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .peakLoadBalancingAlgorithm(
                peakLoadBalancingAlgorithm?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .peakStartTime(peakStartTime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rampDownCapacityThresholdPct(rampDownCapacityThresholdPct?.applyValue({ args0 -> args0 }))
            .rampDownForceLogoffUsers(rampDownForceLogoffUsers?.applyValue({ args0 -> args0 }))
            .rampDownLoadBalancingAlgorithm(
                rampDownLoadBalancingAlgorithm?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .rampDownMinimumHostsPct(rampDownMinimumHostsPct?.applyValue({ args0 -> args0 }))
            .rampDownNotificationMessage(rampDownNotificationMessage?.applyValue({ args0 -> args0 }))
            .rampDownStartTime(rampDownStartTime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rampDownStopHostsWhen(
                rampDownStopHostsWhen?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .rampDownWaitTimeMinutes(rampDownWaitTimeMinutes?.applyValue({ args0 -> args0 }))
            .rampUpCapacityThresholdPct(rampUpCapacityThresholdPct?.applyValue({ args0 -> args0 }))
            .rampUpLoadBalancingAlgorithm(
                rampUpLoadBalancingAlgorithm?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .rampUpMinimumHostsPct(rampUpMinimumHostsPct?.applyValue({ args0 -> args0 }))
            .rampUpStartTime(rampUpStartTime?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scalingPlanName(scalingPlanName?.applyValue({ args0 -> args0 }))
            .scalingPlanScheduleName(scalingPlanScheduleName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScalingPlanPooledScheduleArgs].
 */
@PulumiTagMarker
public class ScalingPlanPooledScheduleArgsBuilder internal constructor() {
    private var daysOfWeek: Output<List<Either<String, DayOfWeek>>>? = null

    private var offPeakLoadBalancingAlgorithm:
        Output<Either<String, SessionHostLoadBalancingAlgorithm>>? = null

    private var offPeakStartTime: Output<TimeArgs>? = null

    private var peakLoadBalancingAlgorithm: Output<Either<String, SessionHostLoadBalancingAlgorithm>>? =
        null

    private var peakStartTime: Output<TimeArgs>? = null

    private var rampDownCapacityThresholdPct: Output<Int>? = null

    private var rampDownForceLogoffUsers: Output<Boolean>? = null

    private var rampDownLoadBalancingAlgorithm:
        Output<Either<String, SessionHostLoadBalancingAlgorithm>>? = null

    private var rampDownMinimumHostsPct: Output<Int>? = null

    private var rampDownNotificationMessage: Output<String>? = null

    private var rampDownStartTime: Output<TimeArgs>? = null

    private var rampDownStopHostsWhen: Output<Either<String, StopHostsWhen>>? = null

    private var rampDownWaitTimeMinutes: Output<Int>? = null

    private var rampUpCapacityThresholdPct: Output<Int>? = null

    private var rampUpLoadBalancingAlgorithm:
        Output<Either<String, SessionHostLoadBalancingAlgorithm>>? = null

    private var rampUpMinimumHostsPct: Output<Int>? = null

    private var rampUpStartTime: Output<TimeArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var scalingPlanName: Output<String>? = null

    private var scalingPlanScheduleName: Output<String>? = null

    /**
     * @param value Set of days of the week on which this schedule is active.
     */
    @JvmName("nndbtvwvqoatrkrr")
    public suspend fun daysOfWeek(`value`: Output<List<Either<String, DayOfWeek>>>) {
        this.daysOfWeek = value
    }

    @JvmName("ijdovsmolkllgedr")
    public suspend fun daysOfWeek(vararg values: Output<Either<String, DayOfWeek>>) {
        this.daysOfWeek = Output.all(values.asList())
    }

    /**
     * @param values Set of days of the week on which this schedule is active.
     */
    @JvmName("agspjcqnbxvkymdr")
    public suspend fun daysOfWeek(values: List<Output<Either<String, DayOfWeek>>>) {
        this.daysOfWeek = Output.all(values)
    }

    /**
     * @param value Load balancing algorithm for off-peak period.
     */
    @JvmName("rpshutgxthcvwxbp")
    public suspend
    fun offPeakLoadBalancingAlgorithm(`value`: Output<Either<String, SessionHostLoadBalancingAlgorithm>>) {
        this.offPeakLoadBalancingAlgorithm = value
    }

    /**
     * @param value Starting time for off-peak period.
     */
    @JvmName("mqceawedtqorvpdf")
    public suspend fun offPeakStartTime(`value`: Output<TimeArgs>) {
        this.offPeakStartTime = value
    }

    /**
     * @param value Load balancing algorithm for peak period.
     */
    @JvmName("oldffxwvumojdfbp")
    public suspend
    fun peakLoadBalancingAlgorithm(`value`: Output<Either<String, SessionHostLoadBalancingAlgorithm>>) {
        this.peakLoadBalancingAlgorithm = value
    }

    /**
     * @param value Starting time for peak period.
     */
    @JvmName("avksviciwjxbigst")
    public suspend fun peakStartTime(`value`: Output<TimeArgs>) {
        this.peakStartTime = value
    }

    /**
     * @param value Capacity threshold for ramp down period.
     */
    @JvmName("lqqxpqlekmaujyoi")
    public suspend fun rampDownCapacityThresholdPct(`value`: Output<Int>) {
        this.rampDownCapacityThresholdPct = value
    }

    /**
     * @param value Should users be logged off forcefully from hosts.
     */
    @JvmName("gksqvfvvcccgdwre")
    public suspend fun rampDownForceLogoffUsers(`value`: Output<Boolean>) {
        this.rampDownForceLogoffUsers = value
    }

    /**
     * @param value Load balancing algorithm for ramp down period.
     */
    @JvmName("ggkrjlpjkgmqnklk")
    public suspend
    fun rampDownLoadBalancingAlgorithm(`value`: Output<Either<String, SessionHostLoadBalancingAlgorithm>>) {
        this.rampDownLoadBalancingAlgorithm = value
    }

    /**
     * @param value Minimum host percentage for ramp down period.
     */
    @JvmName("nsmumkltojcojrwo")
    public suspend fun rampDownMinimumHostsPct(`value`: Output<Int>) {
        this.rampDownMinimumHostsPct = value
    }

    /**
     * @param value Notification message for users during ramp down period.
     */
    @JvmName("dxmxvqmpumplucoh")
    public suspend fun rampDownNotificationMessage(`value`: Output<String>) {
        this.rampDownNotificationMessage = value
    }

    /**
     * @param value Starting time for ramp down period.
     */
    @JvmName("bloaalwveicwknom")
    public suspend fun rampDownStartTime(`value`: Output<TimeArgs>) {
        this.rampDownStartTime = value
    }

    /**
     * @param value Specifies when to stop hosts during ramp down period.
     */
    @JvmName("svigrdunnoapryxu")
    public suspend fun rampDownStopHostsWhen(`value`: Output<Either<String, StopHostsWhen>>) {
        this.rampDownStopHostsWhen = value
    }

    /**
     * @param value Number of minutes to wait to stop hosts during ramp down period.
     */
    @JvmName("tlkpeebxlnvdpygx")
    public suspend fun rampDownWaitTimeMinutes(`value`: Output<Int>) {
        this.rampDownWaitTimeMinutes = value
    }

    /**
     * @param value Capacity threshold for ramp up period.
     */
    @JvmName("pcuwieivtjubggld")
    public suspend fun rampUpCapacityThresholdPct(`value`: Output<Int>) {
        this.rampUpCapacityThresholdPct = value
    }

    /**
     * @param value Load balancing algorithm for ramp up period.
     */
    @JvmName("knbntxwoxrbfrosd")
    public suspend
    fun rampUpLoadBalancingAlgorithm(`value`: Output<Either<String, SessionHostLoadBalancingAlgorithm>>) {
        this.rampUpLoadBalancingAlgorithm = value
    }

    /**
     * @param value Minimum host percentage for ramp up period.
     */
    @JvmName("pragyorcutmtewhe")
    public suspend fun rampUpMinimumHostsPct(`value`: Output<Int>) {
        this.rampUpMinimumHostsPct = value
    }

    /**
     * @param value Starting time for ramp up period.
     */
    @JvmName("opqekvxsborjaiav")
    public suspend fun rampUpStartTime(`value`: Output<TimeArgs>) {
        this.rampUpStartTime = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uhrqciprhjturmya")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the scaling plan.
     */
    @JvmName("cabblahhtipciyew")
    public suspend fun scalingPlanName(`value`: Output<String>) {
        this.scalingPlanName = value
    }

    /**
     * @param value The name of the ScalingPlanSchedule
     */
    @JvmName("xgatofqbifqonbob")
    public suspend fun scalingPlanScheduleName(`value`: Output<String>) {
        this.scalingPlanScheduleName = value
    }

    /**
     * @param value Set of days of the week on which this schedule is active.
     */
    @JvmName("woebdcyswffsngcu")
    public suspend fun daysOfWeek(`value`: List<Either<String, DayOfWeek>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daysOfWeek = mapped
    }

    /**
     * @param values Set of days of the week on which this schedule is active.
     */
    @JvmName("fygvxwoidtgvxxpl")
    public suspend fun daysOfWeek(vararg values: Either<String, DayOfWeek>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.daysOfWeek = mapped
    }

    /**
     * @param value Load balancing algorithm for off-peak period.
     */
    @JvmName("wktxftyfsuqolftj")
    public suspend
    fun offPeakLoadBalancingAlgorithm(`value`: Either<String, SessionHostLoadBalancingAlgorithm>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offPeakLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Load balancing algorithm for off-peak period.
     */
    @JvmName("nuisrwaskhhogkkq")
    public fun offPeakLoadBalancingAlgorithm(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHostLoadBalancingAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offPeakLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Load balancing algorithm for off-peak period.
     */
    @JvmName("otxtwchfqdmjiohk")
    public fun offPeakLoadBalancingAlgorithm(`value`: SessionHostLoadBalancingAlgorithm) {
        val toBeMapped = Either.ofRight<String, SessionHostLoadBalancingAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offPeakLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Starting time for off-peak period.
     */
    @JvmName("evqrfyxndfdwifyr")
    public suspend fun offPeakStartTime(`value`: TimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offPeakStartTime = mapped
    }

    /**
     * @param argument Starting time for off-peak period.
     */
    @JvmName("obourpxvcevnfpvj")
    public suspend fun offPeakStartTime(argument: suspend TimeArgsBuilder.() -> Unit) {
        val toBeMapped = TimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.offPeakStartTime = mapped
    }

    /**
     * @param value Load balancing algorithm for peak period.
     */
    @JvmName("qhkaxocwrjxhbfrm")
    public suspend
    fun peakLoadBalancingAlgorithm(`value`: Either<String, SessionHostLoadBalancingAlgorithm>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peakLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Load balancing algorithm for peak period.
     */
    @JvmName("bdtswudqhsmckiyl")
    public fun peakLoadBalancingAlgorithm(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHostLoadBalancingAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peakLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Load balancing algorithm for peak period.
     */
    @JvmName("cayselwrbcimdbiu")
    public fun peakLoadBalancingAlgorithm(`value`: SessionHostLoadBalancingAlgorithm) {
        val toBeMapped = Either.ofRight<String, SessionHostLoadBalancingAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peakLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Starting time for peak period.
     */
    @JvmName("ibvpxoprrfqpqqpc")
    public suspend fun peakStartTime(`value`: TimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peakStartTime = mapped
    }

    /**
     * @param argument Starting time for peak period.
     */
    @JvmName("cfjdsenddxpwmotb")
    public suspend fun peakStartTime(argument: suspend TimeArgsBuilder.() -> Unit) {
        val toBeMapped = TimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.peakStartTime = mapped
    }

    /**
     * @param value Capacity threshold for ramp down period.
     */
    @JvmName("ouiwuccjfvhfdjmf")
    public suspend fun rampDownCapacityThresholdPct(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownCapacityThresholdPct = mapped
    }

    /**
     * @param value Should users be logged off forcefully from hosts.
     */
    @JvmName("nyxojnjdpcffxmtd")
    public suspend fun rampDownForceLogoffUsers(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownForceLogoffUsers = mapped
    }

    /**
     * @param value Load balancing algorithm for ramp down period.
     */
    @JvmName("vknjttivmhfbxhxa")
    public suspend
    fun rampDownLoadBalancingAlgorithm(`value`: Either<String, SessionHostLoadBalancingAlgorithm>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Load balancing algorithm for ramp down period.
     */
    @JvmName("heulllhlehdtjcmu")
    public fun rampDownLoadBalancingAlgorithm(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHostLoadBalancingAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampDownLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Load balancing algorithm for ramp down period.
     */
    @JvmName("ftdbjxjqtclhnuiq")
    public fun rampDownLoadBalancingAlgorithm(`value`: SessionHostLoadBalancingAlgorithm) {
        val toBeMapped = Either.ofRight<String, SessionHostLoadBalancingAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampDownLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Minimum host percentage for ramp down period.
     */
    @JvmName("dkriovgdknwsrtna")
    public suspend fun rampDownMinimumHostsPct(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownMinimumHostsPct = mapped
    }

    /**
     * @param value Notification message for users during ramp down period.
     */
    @JvmName("sbejxqfmidmbaqyn")
    public suspend fun rampDownNotificationMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownNotificationMessage = mapped
    }

    /**
     * @param value Starting time for ramp down period.
     */
    @JvmName("soppikvhefcwowgh")
    public suspend fun rampDownStartTime(`value`: TimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownStartTime = mapped
    }

    /**
     * @param argument Starting time for ramp down period.
     */
    @JvmName("qrcmamwgotncmspe")
    public suspend fun rampDownStartTime(argument: suspend TimeArgsBuilder.() -> Unit) {
        val toBeMapped = TimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rampDownStartTime = mapped
    }

    /**
     * @param value Specifies when to stop hosts during ramp down period.
     */
    @JvmName("beqekknqbrbvrnju")
    public suspend fun rampDownStopHostsWhen(`value`: Either<String, StopHostsWhen>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownStopHostsWhen = mapped
    }

    /**
     * @param value Specifies when to stop hosts during ramp down period.
     */
    @JvmName("mnmcpviaysgtncoo")
    public fun rampDownStopHostsWhen(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StopHostsWhen>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampDownStopHostsWhen = mapped
    }

    /**
     * @param value Specifies when to stop hosts during ramp down period.
     */
    @JvmName("bokvbrbjyqrcpkfd")
    public fun rampDownStopHostsWhen(`value`: StopHostsWhen) {
        val toBeMapped = Either.ofRight<String, StopHostsWhen>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampDownStopHostsWhen = mapped
    }

    /**
     * @param value Number of minutes to wait to stop hosts during ramp down period.
     */
    @JvmName("hmevdmvtpbqrjxpl")
    public suspend fun rampDownWaitTimeMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampDownWaitTimeMinutes = mapped
    }

    /**
     * @param value Capacity threshold for ramp up period.
     */
    @JvmName("qpwyuwqougssqqou")
    public suspend fun rampUpCapacityThresholdPct(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampUpCapacityThresholdPct = mapped
    }

    /**
     * @param value Load balancing algorithm for ramp up period.
     */
    @JvmName("vnlvrefjrqjbvogs")
    public suspend
    fun rampUpLoadBalancingAlgorithm(`value`: Either<String, SessionHostLoadBalancingAlgorithm>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampUpLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Load balancing algorithm for ramp up period.
     */
    @JvmName("ihcpmmwutictmouo")
    public fun rampUpLoadBalancingAlgorithm(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionHostLoadBalancingAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampUpLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Load balancing algorithm for ramp up period.
     */
    @JvmName("hpbjtckfeetydmsk")
    public fun rampUpLoadBalancingAlgorithm(`value`: SessionHostLoadBalancingAlgorithm) {
        val toBeMapped = Either.ofRight<String, SessionHostLoadBalancingAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rampUpLoadBalancingAlgorithm = mapped
    }

    /**
     * @param value Minimum host percentage for ramp up period.
     */
    @JvmName("adjqofhvyjcnadrf")
    public suspend fun rampUpMinimumHostsPct(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampUpMinimumHostsPct = mapped
    }

    /**
     * @param value Starting time for ramp up period.
     */
    @JvmName("mtgreivvuqaponxq")
    public suspend fun rampUpStartTime(`value`: TimeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rampUpStartTime = mapped
    }

    /**
     * @param argument Starting time for ramp up period.
     */
    @JvmName("tuekxhxtrgurktnl")
    public suspend fun rampUpStartTime(argument: suspend TimeArgsBuilder.() -> Unit) {
        val toBeMapped = TimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rampUpStartTime = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ladurfvwprtfejoc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the scaling plan.
     */
    @JvmName("brnrwjjbccwttrhp")
    public suspend fun scalingPlanName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingPlanName = mapped
    }

    /**
     * @param value The name of the ScalingPlanSchedule
     */
    @JvmName("xshwfuvnfhrkwtad")
    public suspend fun scalingPlanScheduleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingPlanScheduleName = mapped
    }

    internal fun build(): ScalingPlanPooledScheduleArgs = ScalingPlanPooledScheduleArgs(
        daysOfWeek = daysOfWeek,
        offPeakLoadBalancingAlgorithm = offPeakLoadBalancingAlgorithm,
        offPeakStartTime = offPeakStartTime,
        peakLoadBalancingAlgorithm = peakLoadBalancingAlgorithm,
        peakStartTime = peakStartTime,
        rampDownCapacityThresholdPct = rampDownCapacityThresholdPct,
        rampDownForceLogoffUsers = rampDownForceLogoffUsers,
        rampDownLoadBalancingAlgorithm = rampDownLoadBalancingAlgorithm,
        rampDownMinimumHostsPct = rampDownMinimumHostsPct,
        rampDownNotificationMessage = rampDownNotificationMessage,
        rampDownStartTime = rampDownStartTime,
        rampDownStopHostsWhen = rampDownStopHostsWhen,
        rampDownWaitTimeMinutes = rampDownWaitTimeMinutes,
        rampUpCapacityThresholdPct = rampUpCapacityThresholdPct,
        rampUpLoadBalancingAlgorithm = rampUpLoadBalancingAlgorithm,
        rampUpMinimumHostsPct = rampUpMinimumHostsPct,
        rampUpStartTime = rampUpStartTime,
        resourceGroupName = resourceGroupName,
        scalingPlanName = scalingPlanName,
        scalingPlanScheduleName = scalingPlanScheduleName,
    )
}
