@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.inputs

import com.pulumi.azurenative.desktopvirtualization.inputs.GetAppAttachPackagePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property appAttachPackageName The name of the App Attach package arm object
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAppAttachPackagePlainArgs(
    public val appAttachPackageName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.inputs.GetAppAttachPackagePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.desktopvirtualization.inputs.GetAppAttachPackagePlainArgs =
        com.pulumi.azurenative.desktopvirtualization.inputs.GetAppAttachPackagePlainArgs.builder()
            .appAttachPackageName(appAttachPackageName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAppAttachPackagePlainArgs].
 */
@PulumiTagMarker
public class GetAppAttachPackagePlainArgsBuilder internal constructor() {
    private var appAttachPackageName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the App Attach package arm object
     */
    @JvmName("rarodagsukydwdtv")
    public suspend fun appAttachPackageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.appAttachPackageName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("npilemnsyeebnmoe")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAppAttachPackagePlainArgs = GetAppAttachPackagePlainArgs(
        appAttachPackageName = appAttachPackageName ?: throw
            PulumiNullFieldException("appAttachPackageName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
