@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.inputs

import com.pulumi.azurenative.desktopvirtualization.inputs.ScalingHostPoolReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Scaling plan reference to hostpool.
 * @property hostPoolArmPath Arm path of referenced hostpool.
 * @property scalingPlanEnabled Is the scaling plan enabled for this hostpool.
 */
public data class ScalingHostPoolReferenceArgs(
    public val hostPoolArmPath: Output<String>? = null,
    public val scalingPlanEnabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.inputs.ScalingHostPoolReferenceArgs> {
    override fun toJava():
        com.pulumi.azurenative.desktopvirtualization.inputs.ScalingHostPoolReferenceArgs =
        com.pulumi.azurenative.desktopvirtualization.inputs.ScalingHostPoolReferenceArgs.builder()
            .hostPoolArmPath(hostPoolArmPath?.applyValue({ args0 -> args0 }))
            .scalingPlanEnabled(scalingPlanEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScalingHostPoolReferenceArgs].
 */
@PulumiTagMarker
public class ScalingHostPoolReferenceArgsBuilder internal constructor() {
    private var hostPoolArmPath: Output<String>? = null

    private var scalingPlanEnabled: Output<Boolean>? = null

    /**
     * @param value Arm path of referenced hostpool.
     */
    @JvmName("dycncpwugowvuqkh")
    public suspend fun hostPoolArmPath(`value`: Output<String>) {
        this.hostPoolArmPath = value
    }

    /**
     * @param value Is the scaling plan enabled for this hostpool.
     */
    @JvmName("iisawqjmdpdpvhka")
    public suspend fun scalingPlanEnabled(`value`: Output<Boolean>) {
        this.scalingPlanEnabled = value
    }

    /**
     * @param value Arm path of referenced hostpool.
     */
    @JvmName("nimugqgtcaiqhhhf")
    public suspend fun hostPoolArmPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostPoolArmPath = mapped
    }

    /**
     * @param value Is the scaling plan enabled for this hostpool.
     */
    @JvmName("oeqqjcnymjusoiff")
    public suspend fun scalingPlanEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingPlanEnabled = mapped
    }

    internal fun build(): ScalingHostPoolReferenceArgs = ScalingHostPoolReferenceArgs(
        hostPoolArmPath = hostPoolArmPath,
        scalingPlanEnabled = scalingPlanEnabled,
    )
}
