@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Schema for Application properties.
 * @property applicationType Resource Type of Application.
 * @property commandLineArguments Command Line Arguments for Application.
 * @property commandLineSetting Specifies whether this published application can be launched with command line arguments provided by the client, command line arguments specified at publish time, or no command line arguments at all.
 * @property description Description of Application.
 * @property filePath Specifies a path for the executable file for the application.
 * @property friendlyName Friendly name of Application.
 * @property iconContent the icon a 64 bit string as a byte array.
 * @property iconHash Hash of the icon.
 * @property iconIndex Index of the icon.
 * @property iconPath Path to icon.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property msixPackageApplicationId Specifies the package application Id for MSIX applications
 * @property msixPackageFamilyName Specifies the package family name for MSIX applications
 * @property name The name of the resource
 * @property objectId ObjectId of Application. (internal use)
 * @property showInPortal Specifies whether to show the RemoteApp program in the RD Web Access server.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetApplicationResult(
    public val applicationType: String? = null,
    public val commandLineArguments: String? = null,
    public val commandLineSetting: String,
    public val description: String? = null,
    public val filePath: String? = null,
    public val friendlyName: String? = null,
    public val iconContent: String,
    public val iconHash: String,
    public val iconIndex: Int? = null,
    public val iconPath: String? = null,
    public val id: String,
    public val msixPackageApplicationId: String? = null,
    public val msixPackageFamilyName: String? = null,
    public val name: String,
    public val objectId: String,
    public val showInPortal: Boolean? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.desktopvirtualization.outputs.GetApplicationResult):
            GetApplicationResult = GetApplicationResult(
            applicationType = javaType.applicationType().map({ args0 -> args0 }).orElse(null),
            commandLineArguments = javaType.commandLineArguments().map({ args0 -> args0 }).orElse(null),
            commandLineSetting = javaType.commandLineSetting(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            filePath = javaType.filePath().map({ args0 -> args0 }).orElse(null),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            iconContent = javaType.iconContent(),
            iconHash = javaType.iconHash(),
            iconIndex = javaType.iconIndex().map({ args0 -> args0 }).orElse(null),
            iconPath = javaType.iconPath().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            msixPackageApplicationId = javaType.msixPackageApplicationId().map({ args0 -> args0 }).orElse(null),
            msixPackageFamilyName = javaType.msixPackageFamilyName().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            objectId = javaType.objectId(),
            showInPortal = javaType.showInPortal().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
