@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Represents a HostPool definition.
 * @property agentUpdate The session host configuration for updating agent, monitoring agent, and stack component.
 * @property applicationGroupReferences List of applicationGroup links.
 * @property cloudPcResource Is cloud pc resource.
 * @property customRdpProperty Custom rdp property of HostPool.
 * @property description Description of HostPool.
 * @property etag The etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.
 * @property friendlyName Friendly name of HostPool.
 * @property hostPoolType HostPool type for desktop.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
 * @property loadBalancerType The type of the load balancer.
 * @property location The geo-location where the resource lives
 * @property managedBy The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
 * @property maxSessionLimit The max session limit of HostPool.
 * @property name The name of the resource
 * @property objectId ObjectId of HostPool. (internal use)
 * @property personalDesktopAssignmentType PersonalDesktopAssignment type for HostPool.
 * @property plan
 * @property preferredAppGroupType The type of preferred application group type, default to Desktop Application Group
 * @property registrationInfo The registration info of HostPool.
 * @property ring The ring number of HostPool.
 * @property sku
 * @property ssoClientId ClientId for the registered Relying Party used to issue WVD SSO certificates.
 * @property ssoClientSecretKeyVaultPath Path to Azure KeyVault storing the secret used for communication to ADFS.
 * @property ssoSecretType The type of single sign on Secret Type.
 * @property ssoadfsAuthority URL to customer ADFS server for signing WVD SSO certificates.
 * @property startVMOnConnect The flag to turn on/off StartVMOnConnect feature.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property validationEnvironment Is validation environment.
 * @property vmTemplate VM template for sessionhosts configuration within hostpool.
 */
public data class GetHostPoolResult(
    public val agentUpdate: AgentUpdatePropertiesResponse? = null,
    public val applicationGroupReferences: List<String>,
    public val cloudPcResource: Boolean,
    public val customRdpProperty: String? = null,
    public val description: String? = null,
    public val etag: String,
    public val friendlyName: String? = null,
    public val hostPoolType: String,
    public val id: String,
    public val identity: ResourceModelWithAllowedPropertySetResponseIdentity? = null,
    public val kind: String? = null,
    public val loadBalancerType: String,
    public val location: String? = null,
    public val managedBy: String? = null,
    public val maxSessionLimit: Int? = null,
    public val name: String,
    public val objectId: String,
    public val personalDesktopAssignmentType: String? = null,
    public val plan: ResourceModelWithAllowedPropertySetResponsePlan? = null,
    public val preferredAppGroupType: String,
    public val registrationInfo: RegistrationInfoResponse? = null,
    public val ring: Int? = null,
    public val sku: ResourceModelWithAllowedPropertySetResponseSku? = null,
    public val ssoClientId: String? = null,
    public val ssoClientSecretKeyVaultPath: String? = null,
    public val ssoSecretType: String? = null,
    public val ssoadfsAuthority: String? = null,
    public val startVMOnConnect: Boolean? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val validationEnvironment: Boolean? = null,
    public val vmTemplate: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.desktopvirtualization.outputs.GetHostPoolResult):
            GetHostPoolResult = GetHostPoolResult(
            agentUpdate = javaType.agentUpdate().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.AgentUpdatePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            applicationGroupReferences = javaType.applicationGroupReferences().map({ args0 -> args0 }),
            cloudPcResource = javaType.cloudPcResource(),
            customRdpProperty = javaType.customRdpProperty().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            hostPoolType = javaType.hostPoolType(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponseIdentity.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            loadBalancerType = javaType.loadBalancerType(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            managedBy = javaType.managedBy().map({ args0 -> args0 }).orElse(null),
            maxSessionLimit = javaType.maxSessionLimit().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            objectId = javaType.objectId(),
            personalDesktopAssignmentType = javaType.personalDesktopAssignmentType().map({ args0 ->
                args0
            }).orElse(null),
            plan = javaType.plan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponsePlan.Companion.toKotlin(args0)
                })
            }).orElse(null),
            preferredAppGroupType = javaType.preferredAppGroupType(),
            registrationInfo = javaType.registrationInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.RegistrationInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ring = javaType.ring().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.ResourceModelWithAllowedPropertySetResponseSku.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ssoClientId = javaType.ssoClientId().map({ args0 -> args0 }).orElse(null),
            ssoClientSecretKeyVaultPath = javaType.ssoClientSecretKeyVaultPath().map({ args0 ->
                args0
            }).orElse(null),
            ssoSecretType = javaType.ssoSecretType().map({ args0 -> args0 }).orElse(null),
            ssoadfsAuthority = javaType.ssoadfsAuthority().map({ args0 -> args0 }).orElse(null),
            startVMOnConnect = javaType.startVMOnConnect().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            validationEnvironment = javaType.validationEnvironment().map({ args0 -> args0 }).orElse(null),
            vmTemplate = javaType.vmTemplate().map({ args0 -> args0 }).orElse(null),
        )
    }
}
