@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Schema for MSIX Package Application properties.
 * @property appId Package Application Id, found in appxmanifest.xml.
 * @property appUserModelID Used to activate Package Application. Consists of Package Name and ApplicationID. Found in appxmanifest.xml.
 * @property description Description of Package Application.
 * @property friendlyName User friendly name.
 * @property iconImageName User friendly name.
 * @property rawIcon the icon a 64 bit string as a byte array.
 * @property rawPng the icon a 64 bit string as a byte array.
 */
public data class MsixPackageApplicationsResponse(
    public val appId: String? = null,
    public val appUserModelID: String? = null,
    public val description: String? = null,
    public val friendlyName: String? = null,
    public val iconImageName: String? = null,
    public val rawIcon: String? = null,
    public val rawPng: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.desktopvirtualization.outputs.MsixPackageApplicationsResponse):
            MsixPackageApplicationsResponse = MsixPackageApplicationsResponse(
            appId = javaType.appId().map({ args0 -> args0 }).orElse(null),
            appUserModelID = javaType.appUserModelID().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            iconImageName = javaType.iconImageName().map({ args0 -> args0 }).orElse(null),
            rawIcon = javaType.rawIcon().map({ args0 -> args0 }).orElse(null),
            rawPng = javaType.rawPng().map({ args0 -> args0 }).orElse(null),
        )
    }
}
