@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Schema for MSIX Package Dependencies properties.
 * @property dependencyName Name of package dependency.
 * @property minVersion Dependency version required.
 * @property publisher Name of dependency publisher.
 */
public data class MsixPackageDependenciesResponse(
    public val dependencyName: String? = null,
    public val minVersion: String? = null,
    public val publisher: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.desktopvirtualization.outputs.MsixPackageDependenciesResponse):
            MsixPackageDependenciesResponse = MsixPackageDependenciesResponse(
            dependencyName = javaType.dependencyName().map({ args0 -> args0 }).orElse(null),
            minVersion = javaType.minVersion().map({ args0 -> args0 }).orElse(null),
            publisher = javaType.publisher().map({ args0 -> args0 }).orElse(null),
        )
    }
}
