@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A ScalingPlanPooledSchedule.
 * @property daysOfWeek Set of days of the week on which this schedule is active.
 * @property name Name of the ScalingPlanPooledSchedule.
 * @property offPeakLoadBalancingAlgorithm Load balancing algorithm for off-peak period.
 * @property offPeakStartTime Starting time for off-peak period.
 * @property peakLoadBalancingAlgorithm Load balancing algorithm for peak period.
 * @property peakStartTime Starting time for peak period.
 * @property rampDownCapacityThresholdPct Capacity threshold for ramp down period.
 * @property rampDownForceLogoffUsers Should users be logged off forcefully from hosts.
 * @property rampDownLoadBalancingAlgorithm Load balancing algorithm for ramp down period.
 * @property rampDownMinimumHostsPct Minimum host percentage for ramp down period.
 * @property rampDownNotificationMessage Notification message for users during ramp down period.
 * @property rampDownStartTime Starting time for ramp down period.
 * @property rampDownStopHostsWhen Specifies when to stop hosts during ramp down period.
 * @property rampDownWaitTimeMinutes Number of minutes to wait to stop hosts during ramp down period.
 * @property rampUpCapacityThresholdPct Capacity threshold for ramp up period.
 * @property rampUpLoadBalancingAlgorithm Load balancing algorithm for ramp up period.
 * @property rampUpMinimumHostsPct Minimum host percentage for ramp up period.
 * @property rampUpStartTime Starting time for ramp up period.
 */
public data class ScalingScheduleResponse(
    public val daysOfWeek: List<String>? = null,
    public val name: String? = null,
    public val offPeakLoadBalancingAlgorithm: String? = null,
    public val offPeakStartTime: TimeResponse? = null,
    public val peakLoadBalancingAlgorithm: String? = null,
    public val peakStartTime: TimeResponse? = null,
    public val rampDownCapacityThresholdPct: Int? = null,
    public val rampDownForceLogoffUsers: Boolean? = null,
    public val rampDownLoadBalancingAlgorithm: String? = null,
    public val rampDownMinimumHostsPct: Int? = null,
    public val rampDownNotificationMessage: String? = null,
    public val rampDownStartTime: TimeResponse? = null,
    public val rampDownStopHostsWhen: String? = null,
    public val rampDownWaitTimeMinutes: Int? = null,
    public val rampUpCapacityThresholdPct: Int? = null,
    public val rampUpLoadBalancingAlgorithm: String? = null,
    public val rampUpMinimumHostsPct: Int? = null,
    public val rampUpStartTime: TimeResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.desktopvirtualization.outputs.ScalingScheduleResponse):
            ScalingScheduleResponse = ScalingScheduleResponse(
            daysOfWeek = javaType.daysOfWeek().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            offPeakLoadBalancingAlgorithm = javaType.offPeakLoadBalancingAlgorithm().map({ args0 ->
                args0
            }).orElse(null),
            offPeakStartTime = javaType.offPeakStartTime().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.TimeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            peakLoadBalancingAlgorithm = javaType.peakLoadBalancingAlgorithm().map({ args0 ->
                args0
            }).orElse(null),
            peakStartTime = javaType.peakStartTime().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.TimeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rampDownCapacityThresholdPct = javaType.rampDownCapacityThresholdPct().map({ args0 ->
                args0
            }).orElse(null),
            rampDownForceLogoffUsers = javaType.rampDownForceLogoffUsers().map({ args0 -> args0 }).orElse(null),
            rampDownLoadBalancingAlgorithm = javaType.rampDownLoadBalancingAlgorithm().map({ args0 ->
                args0
            }).orElse(null),
            rampDownMinimumHostsPct = javaType.rampDownMinimumHostsPct().map({ args0 -> args0 }).orElse(null),
            rampDownNotificationMessage = javaType.rampDownNotificationMessage().map({ args0 ->
                args0
            }).orElse(null),
            rampDownStartTime = javaType.rampDownStartTime().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.TimeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rampDownStopHostsWhen = javaType.rampDownStopHostsWhen().map({ args0 -> args0 }).orElse(null),
            rampDownWaitTimeMinutes = javaType.rampDownWaitTimeMinutes().map({ args0 -> args0 }).orElse(null),
            rampUpCapacityThresholdPct = javaType.rampUpCapacityThresholdPct().map({ args0 ->
                args0
            }).orElse(null),
            rampUpLoadBalancingAlgorithm = javaType.rampUpLoadBalancingAlgorithm().map({ args0 ->
                args0
            }).orElse(null),
            rampUpMinimumHostsPct = javaType.rampUpMinimumHostsPct().map({ args0 -> args0 }).orElse(null),
            rampUpStartTime = javaType.rampUpStartTime().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.TimeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
