@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.AttachedNetworkByDevCenterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents an attached NetworkConnection.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2023-08-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### AttachedNetworks_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var attachedNetworkByDevCenter = new AzureNative.DevCenter.AttachedNetworkByDevCenter("attachedNetworkByDevCenter", new()
 *     {
 *         AttachedNetworkConnectionName = "network-uswest3",
 *         DevCenterName = "Contoso",
 *         NetworkConnectionId = "/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/NetworkConnections/network-uswest3",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewAttachedNetworkByDevCenter(ctx, "attachedNetworkByDevCenter", &devcenter.AttachedNetworkByDevCenterArgs{
 * 			AttachedNetworkConnectionName: pulumi.String("network-uswest3"),
 * 			DevCenterName:                 pulumi.String("Contoso"),
 * 			NetworkConnectionId:           pulumi.String("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/NetworkConnections/network-uswest3"),
 * 			ResourceGroupName:             pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.AttachedNetworkByDevCenter;
 * import com.pulumi.azurenative.devcenter.AttachedNetworkByDevCenterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var attachedNetworkByDevCenter = new AttachedNetworkByDevCenter("attachedNetworkByDevCenter", AttachedNetworkByDevCenterArgs.builder()
 *             .attachedNetworkConnectionName("network-uswest3")
 *             .devCenterName("Contoso")
 *             .networkConnectionId("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/rg1/providers/Microsoft.DevCenter/NetworkConnections/network-uswest3")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:AttachedNetworkByDevCenter network-uswest3 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/devcenters/{devCenterName}/attachednetworks/{attachedNetworkConnectionName}
 * ```
 * @property attachedNetworkConnectionName The name of the attached NetworkConnection.
 * @property devCenterName The name of the devcenter.
 * @property networkConnectionId The resource ID of the NetworkConnection you want to attach.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class AttachedNetworkByDevCenterArgs(
    public val attachedNetworkConnectionName: Output<String>? = null,
    public val devCenterName: Output<String>? = null,
    public val networkConnectionId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.AttachedNetworkByDevCenterArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.AttachedNetworkByDevCenterArgs =
        com.pulumi.azurenative.devcenter.AttachedNetworkByDevCenterArgs.builder()
            .attachedNetworkConnectionName(attachedNetworkConnectionName?.applyValue({ args0 -> args0 }))
            .devCenterName(devCenterName?.applyValue({ args0 -> args0 }))
            .networkConnectionId(networkConnectionId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AttachedNetworkByDevCenterArgs].
 */
@PulumiTagMarker
public class AttachedNetworkByDevCenterArgsBuilder internal constructor() {
    private var attachedNetworkConnectionName: Output<String>? = null

    private var devCenterName: Output<String>? = null

    private var networkConnectionId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the attached NetworkConnection.
     */
    @JvmName("htpfnjfmqdiycbhn")
    public suspend fun attachedNetworkConnectionName(`value`: Output<String>) {
        this.attachedNetworkConnectionName = value
    }

    /**
     * @param value The name of the devcenter.
     */
    @JvmName("ndskqevyecbdwpsf")
    public suspend fun devCenterName(`value`: Output<String>) {
        this.devCenterName = value
    }

    /**
     * @param value The resource ID of the NetworkConnection you want to attach.
     */
    @JvmName("akupctliwmckohet")
    public suspend fun networkConnectionId(`value`: Output<String>) {
        this.networkConnectionId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kvcwjmldquvtpdwm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the attached NetworkConnection.
     */
    @JvmName("rqyxswhxvetcxioq")
    public suspend fun attachedNetworkConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachedNetworkConnectionName = mapped
    }

    /**
     * @param value The name of the devcenter.
     */
    @JvmName("uiowupfoqnduskrw")
    public suspend fun devCenterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.devCenterName = mapped
    }

    /**
     * @param value The resource ID of the NetworkConnection you want to attach.
     */
    @JvmName("mlcowxbkbvvkavnf")
    public suspend fun networkConnectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkConnectionId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("utoqlabvuartmajd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): AttachedNetworkByDevCenterArgs = AttachedNetworkByDevCenterArgs(
        attachedNetworkConnectionName = attachedNetworkConnectionName,
        devCenterName = devCenterName,
        networkConnectionId = networkConnectionId,
        resourceGroupName = resourceGroupName,
    )
}
