@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.kotlin.outputs.GitCatalogResponse
import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.devcenter.kotlin.outputs.GitCatalogResponse.Companion.toKotlin as gitCatalogResponseToKotlin
import com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Catalog].
 */
@PulumiTagMarker
public class CatalogResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CatalogArgs = CatalogArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CatalogArgsBuilder.() -> Unit) {
        val builder = CatalogArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Catalog {
        val builtJavaResource = com.pulumi.azurenative.devcenter.Catalog(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Catalog(builtJavaResource)
    }
}

/**
 * Represents a catalog.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2023-08-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### Catalogs_CreateOrUpdateAdo
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var catalog = new AzureNative.DevCenter.Catalog("catalog", new()
 *     {
 *         AdoGit = new AzureNative.DevCenter.Inputs.GitCatalogArgs
 *         {
 *             Branch = "main",
 *             Path = "/templates",
 *             SecretIdentifier = "https://contosokv.vault.azure.net/secrets/CentralRepoPat",
 *             Uri = "https://contoso@dev.azure.com/contoso/contosoOrg/_git/centralrepo-fakecontoso",
 *         },
 *         CatalogName = "CentralCatalog",
 *         DevCenterName = "Contoso",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewCatalog(ctx, "catalog", &devcenter.CatalogArgs{
 * 			AdoGit: &devcenter.GitCatalogArgs{
 * 				Branch:           pulumi.String("main"),
 * 				Path:             pulumi.String("/templates"),
 * 				SecretIdentifier: pulumi.String("https://contosokv.vault.azure.net/secrets/CentralRepoPat"),
 * 				Uri:              pulumi.String("https://contoso@dev.azure.com/contoso/contosoOrg/_git/centralrepo-fakecontoso"),
 * 			},
 * 			CatalogName:       pulumi.String("CentralCatalog"),
 * 			DevCenterName:     pulumi.String("Contoso"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.Catalog;
 * import com.pulumi.azurenative.devcenter.CatalogArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var catalog = new Catalog("catalog", CatalogArgs.builder()
 *             .adoGit(Map.ofEntries(
 *                 Map.entry("branch", "main"),
 *                 Map.entry("path", "/templates"),
 *                 Map.entry("secretIdentifier", "https://contosokv.vault.azure.net/secrets/CentralRepoPat"),
 *                 Map.entry("uri", "https://contoso@dev.azure.com/contoso/contosoOrg/_git/centralrepo-fakecontoso")
 *             ))
 *             .catalogName("CentralCatalog")
 *             .devCenterName("Contoso")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### Catalogs_CreateOrUpdateGitHub
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var catalog = new AzureNative.DevCenter.Catalog("catalog", new()
 *     {
 *         CatalogName = "CentralCatalog",
 *         DevCenterName = "Contoso",
 *         GitHub = new AzureNative.DevCenter.Inputs.GitCatalogArgs
 *         {
 *             Branch = "main",
 *             Path = "/templates",
 *             SecretIdentifier = "https://contosokv.vault.azure.net/secrets/CentralRepoPat",
 *             Uri = "https://github.com/Contoso/centralrepo-fake.git",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewCatalog(ctx, "catalog", &devcenter.CatalogArgs{
 * 			CatalogName:   pulumi.String("CentralCatalog"),
 * 			DevCenterName: pulumi.String("Contoso"),
 * 			GitHub: &devcenter.GitCatalogArgs{
 * 				Branch:           pulumi.String("main"),
 * 				Path:             pulumi.String("/templates"),
 * 				SecretIdentifier: pulumi.String("https://contosokv.vault.azure.net/secrets/CentralRepoPat"),
 * 				Uri:              pulumi.String("https://github.com/Contoso/centralrepo-fake.git"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.Catalog;
 * import com.pulumi.azurenative.devcenter.CatalogArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var catalog = new Catalog("catalog", CatalogArgs.builder()
 *             .catalogName("CentralCatalog")
 *             .devCenterName("Contoso")
 *             .gitHub(Map.ofEntries(
 *                 Map.entry("branch", "main"),
 *                 Map.entry("path", "/templates"),
 *                 Map.entry("secretIdentifier", "https://contosokv.vault.azure.net/secrets/CentralRepoPat"),
 *                 Map.entry("uri", "https://github.com/Contoso/centralrepo-fake.git")
 *             ))
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:Catalog CentralCatalog /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/devcenters/{devCenterName}/catalogs/{catalogName}
 * ```
 */
public class Catalog internal constructor(
    override val javaResource: com.pulumi.azurenative.devcenter.Catalog,
) : KotlinCustomResource(javaResource, CatalogMapper) {
    /**
     * Properties for an Azure DevOps catalog type.
     */
    public val adoGit: Output<GitCatalogResponse>?
        get() = javaResource.adoGit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    gitCatalogResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Properties for a GitHub catalog type.
     */
    public val gitHub: Output<GitCatalogResponse>?
        get() = javaResource.gitHub().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    gitCatalogResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * When the catalog was last synced.
     */
    public val lastSyncTime: Output<String>
        get() = javaResource.lastSyncTime().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The synchronization state of the catalog.
     */
    public val syncState: Output<String>
        get() = javaResource.syncState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CatalogMapper : ResourceMapper<Catalog> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devcenter.Catalog::class == javaResource::class

    override fun map(javaResource: Resource): Catalog = Catalog(
        javaResource as
            com.pulumi.azurenative.devcenter.Catalog,
    )
}

/**
 * @see [Catalog].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Catalog].
 */
public suspend fun catalog(name: String, block: suspend CatalogResourceBuilder.() -> Unit):
    Catalog {
    val builder = CatalogResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Catalog].
 * @param name The _unique_ name of the resulting resource.
 */
public fun catalog(name: String): Catalog {
    val builder = CatalogResourceBuilder()
    builder.name(name)
    return builder.build()
}
