@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.inputs

import com.pulumi.azurenative.devcenter.inputs.GitCatalogArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties for a Git repository catalog.
 * @property branch Git branch.
 * @property path The folder where the catalog items can be found inside the repository.
 * @property secretIdentifier A reference to the Key Vault secret containing a security token to authenticate to a Git repository.
 * @property uri Git URI.
 */
public data class GitCatalogArgs(
    public val branch: Output<String>? = null,
    public val path: Output<String>? = null,
    public val secretIdentifier: Output<String>? = null,
    public val uri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.inputs.GitCatalogArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.inputs.GitCatalogArgs =
        com.pulumi.azurenative.devcenter.inputs.GitCatalogArgs.builder()
            .branch(branch?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .secretIdentifier(secretIdentifier?.applyValue({ args0 -> args0 }))
            .uri(uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GitCatalogArgs].
 */
@PulumiTagMarker
public class GitCatalogArgsBuilder internal constructor() {
    private var branch: Output<String>? = null

    private var path: Output<String>? = null

    private var secretIdentifier: Output<String>? = null

    private var uri: Output<String>? = null

    /**
     * @param value Git branch.
     */
    @JvmName("tdddehwvusxqumro")
    public suspend fun branch(`value`: Output<String>) {
        this.branch = value
    }

    /**
     * @param value The folder where the catalog items can be found inside the repository.
     */
    @JvmName("kitsaatcjkyhijkj")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value A reference to the Key Vault secret containing a security token to authenticate to a Git repository.
     */
    @JvmName("ujllmjhtcxbweeoy")
    public suspend fun secretIdentifier(`value`: Output<String>) {
        this.secretIdentifier = value
    }

    /**
     * @param value Git URI.
     */
    @JvmName("jlwtxplnfcwwtujq")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value Git branch.
     */
    @JvmName("xqkyokmpbpqnsijc")
    public suspend fun branch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branch = mapped
    }

    /**
     * @param value The folder where the catalog items can be found inside the repository.
     */
    @JvmName("prgfoowgvslvgyrm")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value A reference to the Key Vault secret containing a security token to authenticate to a Git repository.
     */
    @JvmName("fxqsbdywjwocorhl")
    public suspend fun secretIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretIdentifier = mapped
    }

    /**
     * @param value Git URI.
     */
    @JvmName("cgxeydxxoqrgikrk")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): GitCatalogArgs = GitCatalogArgs(
        branch = branch,
        path = path,
        secretIdentifier = secretIdentifier,
        uri = uri,
    )
}
