@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.inputs

import com.pulumi.azurenative.devcenter.inputs.ImageReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Image reference information
 * @property id Image ID, or Image version ID. When Image ID is provided, its latest version will be used.
 */
public data class ImageReferenceArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.inputs.ImageReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.inputs.ImageReferenceArgs =
        com.pulumi.azurenative.devcenter.inputs.ImageReferenceArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageReferenceArgs].
 */
@PulumiTagMarker
public class ImageReferenceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Image ID, or Image version ID. When Image ID is provided, its latest version will be used.
     */
    @JvmName("tfhnagqdxkilkbtf")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Image ID, or Image version ID. When Image ID is provided, its latest version will be used.
     */
    @JvmName("qintusmcjvyummer")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): ImageReferenceArgs = ImageReferenceArgs(
        id = id,
    )
}
